/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lexer.JetTokens;

public class JetFunctionLiteralExpression
extends JetExpressionImpl {
    public JetFunctionLiteralExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetFunctionLiteralExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetFunctionLiteralExpression", "accept"));
        }
        return visitor.visitFunctionLiteralExpression(this, data2);
    }

    @NotNull
    public JetFunctionLiteral getFunctionLiteral() {
        JetFunctionLiteral jetFunctionLiteral = (JetFunctionLiteral)this.findChildByType(JetNodeTypes.FUNCTION_LITERAL);
        if (jetFunctionLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFunctionLiteralExpression", "getFunctionLiteral"));
        }
        return jetFunctionLiteral;
    }

    @NotNull
    public List<JetParameter> getValueParameters() {
        List<JetParameter> list2 = this.getFunctionLiteral().getValueParameters();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFunctionLiteralExpression", "getValueParameters"));
        }
        return list2;
    }

    public JetBlockExpression getBodyExpression() {
        return this.getFunctionLiteral().getBodyExpression();
    }

    public boolean hasBlockBody() {
        return this.getFunctionLiteral().hasBlockBody();
    }

    public boolean hasDeclaredReturnType() {
        return this.getFunctionLiteral().getReturnTypeRef() != null;
    }

    @NotNull
    public JetElement asElement() {
        JetFunctionLiteralExpression jetFunctionLiteralExpression = this;
        if (jetFunctionLiteralExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFunctionLiteralExpression", "asElement"));
        }
        return jetFunctionLiteralExpression;
    }

    @NotNull
    public ASTNode getLeftCurlyBrace() {
        ASTNode aSTNode = this.getFunctionLiteral().getNode().findChildByType(JetTokens.LBRACE);
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFunctionLiteralExpression", "getLeftCurlyBrace"));
        }
        return aSTNode;
    }

    @Nullable
    public ASTNode getRightCurlyBrace() {
        return this.getFunctionLiteral().getNode().findChildByType(JetTokens.RBRACE);
    }
}

