/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationImpl;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetImportList;
import org.jetbrains.jet.lang.psi.JetVisitor;

public class JetScript
extends JetDeclarationImpl {
    public JetScript(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetScript", "<init>"));
        }
        super(node);
    }

    @NotNull
    public JetBlockExpression getBlockExpression() {
        JetBlockExpression jetBlockExpression = this.findNotNullChildByClass(JetBlockExpression.class);
        if (jetBlockExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetScript", "getBlockExpression"));
        }
        return jetBlockExpression;
    }

    @Nullable
    public JetImportList getImportList() {
        return this.findChildByClass(JetImportList.class);
    }

    @NotNull
    public List<JetImportDirective> getImportDirectives() {
        JetImportList importList = this.getImportList();
        List<JetImportDirective> list2 = importList != null ? importList.getImports() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetScript", "getImportDirectives"));
        }
        return list2;
    }

    @NotNull
    public List<JetDeclaration> getDeclarations() {
        List<JetDeclaration> list2 = PsiTreeUtil.getChildrenOfTypeAsList(this.getBlockExpression(), JetDeclaration.class);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetScript", "getDeclarations"));
        }
        return list2;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetScript", "accept"));
        }
        return visitor.visitScript(this, data2);
    }
}

