/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.context.GlobalContext;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerBasic;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DependencyKind;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilder;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilderDummy;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BodyResolver;
import org.jetbrains.jet.lang.resolve.DeclarationResolver;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.MutablePackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.OverloadResolver;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TypeHierarchyResolver;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class TopDownAnalyzer {
    @NotNull
    private DeclarationResolver declarationResolver;
    @NotNull
    private TypeHierarchyResolver typeHierarchyResolver;
    @NotNull
    private OverrideResolver overrideResolver;
    @NotNull
    private OverloadResolver overloadResolver;
    @NotNull
    private ModuleDescriptor moduleDescriptor;
    @NotNull
    private MutablePackageFragmentProvider packageFragmentProvider;
    @NotNull
    private BodyResolver bodyResolver;

    public void setDeclarationResolver(@NotNull DeclarationResolver declarationResolver) {
        if (declarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setDeclarationResolver"));
        }
        this.declarationResolver = declarationResolver;
    }

    public void setTypeHierarchyResolver(@NotNull TypeHierarchyResolver typeHierarchyResolver) {
        if (typeHierarchyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeHierarchyResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setTypeHierarchyResolver"));
        }
        this.typeHierarchyResolver = typeHierarchyResolver;
    }

    public void setOverrideResolver(@NotNull OverrideResolver overrideResolver) {
        if (overrideResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setOverrideResolver"));
        }
        this.overrideResolver = overrideResolver;
    }

    public void setOverloadResolver(@NotNull OverloadResolver overloadResolver) {
        if (overloadResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setOverloadResolver"));
        }
        this.overloadResolver = overloadResolver;
    }

    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setModuleDescriptor"));
        }
        this.moduleDescriptor = moduleDescriptor;
    }

    public void setPackageFragmentProvider(@NotNull MutablePackageFragmentProvider packageFragmentProvider) {
        if (packageFragmentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragmentProvider", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setPackageFragmentProvider"));
        }
        this.packageFragmentProvider = packageFragmentProvider;
    }

    public void setBodyResolver(@NotNull BodyResolver bodyResolver) {
        if (bodyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setBodyResolver"));
        }
        this.bodyResolver = bodyResolver;
    }

    public void doProcess(@NotNull TopDownAnalysisContext c, @NotNull JetScope outerScope, @NotNull PackageLikeBuilder owner, @NotNull Collection<? extends PsiElement> declarations) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        c.debug("Enter");
        this.typeHierarchyResolver.process(c, outerScope, owner, declarations);
        this.declarationResolver.process(c);
        this.overrideResolver.process(c);
        this.lockScopes(c);
        this.overloadResolver.process(c);
        if (!c.getTopDownAnalysisParameters().isAnalyzingBootstrapLibrary()) {
            this.bodyResolver.resolveBodies(c);
        }
        c.debug("Exit");
        c.printDebugOutput(System.out);
    }

    private void lockScopes(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "lockScopes"));
        }
        for (ClassDescriptorWithResolutionScopes mutableClassDescriptor : c.getClasses().values()) {
            ((MutableClassDescriptor)mutableClassDescriptor).lockScopes();
        }
        HashSet<FqName> scriptFqNames = Sets.newHashSet();
        for (JetFile file : c.getFileScopes().keySet()) {
            if (!file.isScript()) continue;
            scriptFqNames.add(JetPsiUtil.getFQName(file));
        }
        for (MutablePackageFragmentDescriptor fragment : this.packageFragmentProvider.getAllFragments()) {
            if (scriptFqNames.contains(fragment.getFqName())) continue;
            fragment.getMemberScope().changeLockLevel(WritableScope.LockLevel.READING);
        }
    }

    public static void processClassOrObject(@NotNull GlobalContext globalContext, final @Nullable WritableScope scope, @NotNull ExpressionTypingContext context, final @NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject object2) {
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "processClassOrObject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "processClassOrObject"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "processClassOrObject"));
        }
        if (object2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "processClassOrObject"));
        }
        ModuleDescriptorImpl moduleDescriptor = new ModuleDescriptorImpl(Name.special("<dummy for object>"), Collections.<ImportPath>emptyList(), PlatformToKotlinClassMap.EMPTY);
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(globalContext.getStorageManager(), globalContext.getExceptionTracker(), Predicates.equalTo(object2.getContainingFile()), false, true, Collections.<AnalyzerScriptParameter>emptyList());
        InjectorForTopDownAnalyzerBasic injector = new InjectorForTopDownAnalyzerBasic(object2.getProject(), topDownAnalysisParameters, context.trace, moduleDescriptor);
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisParameters);
        c.setOuterDataFlowInfo(context.dataFlowInfo);
        injector.getTopDownAnalyzer().doProcess(c, context.scope, new PackageLikeBuilder(){

            @Override
            @NotNull
            public DeclarationDescriptor getOwnerForChildren() {
                DeclarationDescriptor declarationDescriptor = containingDeclaration;
                if (declarationDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "getOwnerForChildren"));
                }
                return declarationDescriptor;
            }

            @Override
            public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
                if (classDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "addClassifierDescriptor"));
                }
                if (scope != null) {
                    scope.addClassifierDescriptor(classDescriptor);
                }
            }

            @Override
            public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                if (functionDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "addFunctionDescriptor"));
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
                if (propertyDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "addPropertyDescriptor"));
                }
            }

            @Override
            public PackageLikeBuilder.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptorLite classObjectDescriptor) {
                if (classObjectDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObjectDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "setClassObjectDescriptor"));
                }
                return PackageLikeBuilder.ClassObjectStatus.NOT_ALLOWED;
            }
        }, Collections.singletonList(object2));
    }

    @NotNull
    public TopDownAnalysisContext analyzeFiles(@NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull Collection<JetFile> files) {
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        ((ModuleDescriptorImpl)this.moduleDescriptor).addFragmentProvider(DependencyKind.SOURCES, this.packageFragmentProvider);
        ((ModuleDescriptorImpl)this.moduleDescriptor).addFragmentProvider(DependencyKind.BUILT_INS, KotlinBuiltIns.getInstance().getBuiltInsModule().getPackageFragmentProvider());
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisParameters);
        this.doProcess(c, JetModuleUtil.getSubpackagesOfRootScope(this.moduleDescriptor), new PackageLikeBuilderDummy(), files);
        TopDownAnalysisContext topDownAnalysisContext = c;
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        return topDownAnalysisContext;
    }

    public void prepareForTheNextReplLine(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "prepareForTheNextReplLine"));
        }
        c.getScriptScopes().clear();
        c.getScripts().clear();
    }

    @NotNull
    public MutablePackageFragmentProvider getPackageFragmentProvider() {
        MutablePackageFragmentProvider mutablePackageFragmentProvider = this.packageFragmentProvider;
        if (mutablePackageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "getPackageFragmentProvider"));
        }
        return mutablePackageFragmentProvider;
    }
}

