/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ArgumentTypeResolver {
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;

    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public static boolean isSubtypeOfForArgumentType(@NotNull JetType actualType, @NotNull JetType expectedType) {
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualType", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "isSubtypeOfForArgumentType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "isSubtypeOfForArgumentType"));
        }
        if (actualType == TypeUtils.PLACEHOLDER_FUNCTION_TYPE) {
            return ArgumentTypeResolver.isFunctionOrErrorType(expectedType) || KotlinBuiltIns.getInstance().isAnyOrNullableAny(expectedType);
        }
        return JetTypeChecker.INSTANCE.isSubtypeOf(actualType, expectedType);
    }

    private static boolean isFunctionOrErrorType(@NotNull JetType supertype) {
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "isFunctionOrErrorType"));
        }
        return KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(supertype) || supertype.isError();
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        this.checkTypesWithNoCallee(context, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        if (context.checkArguments == CheckValueArgumentsMode.DISABLED) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || argumentExpression instanceof JetFunctionLiteralExpression) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
        if (resolveFunctionArgumentBodies == CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS) {
            this.checkTypesForFunctionArgumentsWithNoCallee(context);
        }
        for (JetTypeProjection jetTypeProjection : context.call.getTypeArguments()) {
            JetTypeReference typeReference = jetTypeProjection.getTypeReference();
            if (typeReference == null) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(jetTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        }
    }

    public void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "checkTypesForFunctionArgumentsWithNoCallee"));
        }
        if (context.checkArguments == CheckValueArgumentsMode.DISABLED) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || !(argumentExpression instanceof JetFunctionLiteralExpression)) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
        for (JetExpression jetExpression : context.call.getFunctionLiteralArguments()) {
            this.checkArgumentTypeWithNoCallee(context, jetExpression);
        }
    }

    public void checkUnmappedArgumentTypes(CallResolutionContext<?> context, Set<ValueArgument> unmappedArguments) {
        for (ValueArgument valueArgument : unmappedArguments) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
    }

    private void checkArgumentTypeWithNoCallee(CallResolutionContext<?> context, JetExpression argumentExpression) {
        this.expressionTypingServices.getTypeInfo(argumentExpression, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        ArgumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, argumentExpression);
    }

    public static boolean isFunctionLiteralArgument(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "isFunctionLiteralArgument"));
        }
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression) != null;
    }

    @NotNull
    public static JetFunctionLiteralExpression getFunctionLiteralArgument(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        assert (ArgumentTypeResolver.isFunctionLiteralArgument(expression));
        JetFunctionLiteralExpression jetFunctionLiteralExpression = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression);
        if (jetFunctionLiteralExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        return jetFunctionLiteralExpression;
    }

    @Nullable
    private static JetFunctionLiteralExpression getFunctionLiteralArgumentIfAny(@NotNull JetExpression expression) {
        JetElement lastStatementInABlock;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgumentIfAny"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression, false);
        if (deparenthesizedExpression instanceof JetBlockExpression && (lastStatementInABlock = JetPsiUtil.getLastStatementInABlock((JetBlockExpression)deparenthesizedExpression)) instanceof JetExpression) {
            deparenthesizedExpression = JetPsiUtil.deparenthesize((JetExpression)lastStatementInABlock, false);
        }
        if (deparenthesizedExpression instanceof JetFunctionLiteralExpression) {
            return (JetFunctionLiteralExpression)deparenthesizedExpression;
        }
        return null;
    }

    @NotNull
    public JetTypeInfo getArgumentTypeInfo(@Nullable JetExpression expression, @NotNull CallResolutionContext<?> context, @NotNull CallResolverUtil.ResolveArgumentsMode resolveArgumentsMode) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        if (resolveArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveArgumentsMode", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        if (expression == null) {
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(null, context.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (ArgumentTypeResolver.isFunctionLiteralArgument(expression)) {
            JetTypeInfo jetTypeInfo = this.getFunctionLiteralTypeInfo(expression, ArgumentTypeResolver.getFunctionLiteralArgument(expression), context, resolveArgumentsMode);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression, context.trace.getBindingContext());
        if (recordedTypeInfo != null) {
            JetTypeInfo jetTypeInfo = recordedTypeInfo;
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        Object newContext = ((CallResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.DEPENDENT);
        JetTypeInfo jetTypeInfo = this.expressionTypingServices.getTypeInfo(expression, (ResolutionContext)newContext);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getFunctionLiteralTypeInfo(@NotNull JetExpression expression, @NotNull JetFunctionLiteralExpression functionLiteralExpression, @NotNull CallResolutionContext<?> context, @NotNull CallResolverUtil.ResolveArgumentsMode resolveArgumentsMode) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (functionLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteralExpression", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (resolveArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveArgumentsMode", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (resolveArgumentsMode == CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            JetType type = this.getShapeTypeOfFunctionLiteral(functionLiteralExpression, context.scope, context.trace, true);
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(type, context.dataFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.expressionTypingServices.getTypeInfo(expression, context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public JetType getShapeTypeOfFunctionLiteral(@NotNull JetFunctionLiteralExpression expression, @NotNull JetScope scope, @NotNull BindingTrace trace, boolean expectedTypeIsUnknown) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (expression.getFunctionLiteral().getValueParameterList() == null) {
            return expectedTypeIsUnknown ? TypeUtils.PLACEHOLDER_FUNCTION_TYPE : KotlinBuiltIns.getInstance().getFunctionType(Annotations.EMPTY, null, Collections.<JetType>emptyList(), TypeUtils.DONT_CARE);
        }
        List<JetParameter> valueParameters = expression.getValueParameters();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList<JetType> parameterTypes = Lists.newArrayList();
        for (JetParameter parameter : valueParameters) {
            parameterTypes.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope, temporaryTrace, TypeUtils.DONT_CARE));
        }
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        JetType returnType2 = this.resolveTypeRefWithDefault(functionLiteral.getReturnTypeRef(), scope, temporaryTrace, TypeUtils.DONT_CARE);
        assert (returnType2 != null);
        JetType receiverType = this.resolveTypeRefWithDefault(functionLiteral.getReceiverTypeRef(), scope, temporaryTrace, null);
        return KotlinBuiltIns.getInstance().getFunctionType(Annotations.EMPTY, receiverType, parameterTypes, returnType2);
    }

    @Nullable
    public JetType resolveTypeRefWithDefault(@Nullable JetTypeReference returnTypeRef, @NotNull JetScope scope, @NotNull BindingTrace trace, @Nullable JetType defaultValue) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "resolveTypeRefWithDefault"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "resolveTypeRefWithDefault"));
        }
        if (returnTypeRef != null) {
            return this.expressionTypingServices.getTypeResolver().resolveType(scope, returnTypeRef, trace, true);
        }
        return defaultValue;
    }

    public <D extends CallableDescriptor> void analyzeArgumentsAndRecordTypes(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "analyzeArgumentsAndRecordTypes"));
        }
        MutableDataFlowInfoForArguments infoForArguments = context.dataFlowInfoForArguments;
        infoForArguments.setInitialDataFlowInfo(context.dataFlowInfo);
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            JetExpression expression = valueArgument.getArgumentExpression();
            if (expression == null) continue;
            CallResolutionContext newContext = (CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            JetTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression, newContext, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            infoForArguments.updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        }
    }

    @Nullable
    public static <D extends CallableDescriptor> JetType updateResultArgumentTypeIfNotDenotable(@NotNull ResolutionContext context, @NotNull JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "updateResultArgumentTypeIfNotDenotable"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "updateResultArgumentTypeIfNotDenotable"));
        }
        JetType type = context.trace.get(BindingContext.EXPRESSION_TYPE, expression);
        if (type != null && !type.getConstructor().isDenotable() && type.getConstructor() instanceof IntegerValueTypeConstructor) {
            IntegerValueTypeConstructor constructor = (IntegerValueTypeConstructor)type.getConstructor();
            JetType primitiveType = TypeUtils.getPrimitiveNumberType(constructor, context.expectedType);
            ArgumentTypeResolver.updateNumberType(primitiveType, expression, context.trace);
            return primitiveType;
        }
        return type;
    }

    public static <D extends CallableDescriptor> void updateNumberType(@NotNull JetType numberType, @Nullable JetExpression expression, @NotNull BindingTrace trace) {
        if (numberType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberType", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "updateNumberType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/ArgumentTypeResolver", "updateNumberType"));
        }
        if (expression == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression, trace, false);
        if (!(expression instanceof JetConstantExpression)) {
            JetElement lastStatement;
            JetExpression deparenthesized = JetPsiUtil.deparenthesize(expression, false);
            if (deparenthesized != expression) {
                ArgumentTypeResolver.updateNumberType(numberType, deparenthesized, trace);
            }
            if (deparenthesized instanceof JetBlockExpression && (lastStatement = JetPsiUtil.getLastStatementInABlock((JetBlockExpression)deparenthesized)) instanceof JetExpression) {
                ArgumentTypeResolver.updateNumberType(numberType, (JetExpression)lastStatement, trace);
            }
            return;
        }
        ConstantExpressionEvaluator.object$.evaluate(expression, trace, numberType);
    }
}

