/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesUtil;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.MethodSignatureChecker;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaSignatureFormatter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaWildcardType;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class PsiBasedMethodSignatureChecker
implements MethodSignatureChecker {
    private static final Logger LOG = Logger.getInstance(PsiBasedMethodSignatureChecker.class);
    private ExternalAnnotationResolver externalAnnotationResolver;
    private ExternalSignatureResolver externalSignatureResolver;

    public void setExternalAnnotationResolver(ExternalAnnotationResolver externalAnnotationResolver) {
        this.externalAnnotationResolver = externalAnnotationResolver;
    }

    public void setExternalSignatureResolver(ExternalSignatureResolver externalSignatureResolver) {
        this.externalSignatureResolver = externalSignatureResolver;
    }

    private void checkFunctionOverridesCorrectly(@NotNull JavaMethod method2, @NotNull FunctionDescriptor function, @NotNull FunctionDescriptor superFunction) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "checkFunctionOverridesCorrectly"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "checkFunctionOverridesCorrectly"));
        }
        if (superFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superFunction", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "checkFunctionOverridesCorrectly"));
        }
        ClassDescriptor klass = (ClassDescriptor)function.getContainingDeclaration();
        ArrayList<TypeSubstitution> substitutions = new ArrayList<TypeSubstitution>();
        while (true) {
            substitutions.add(SubstitutionUtils.buildDeepSubstitutor(klass.getDefaultType()).getSubstitution());
            if (!klass.isInner()) break;
            klass = (ClassDescriptor)klass.getContainingDeclaration();
        }
        TypeSubstitutor substitutor = TypeSubstitutor.create(substitutions.toArray(new TypeSubstitution[substitutions.size()]));
        FunctionDescriptor superFunctionSubstituted = superFunction.substitute(substitutor);
        assert (superFunctionSubstituted != null) : "Couldn't substitute super function: " + superFunction + ", substitutor = " + substitutor;
        OverridingUtil.OverrideCompatibilityInfo.Result overridableResult = OverridingUtil.isOverridableBy(superFunctionSubstituted, function).getResult();
        boolean paramsOk = overridableResult == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
        boolean returnTypeOk = OverridingUtil.isReturnTypeOkForOverride(JetTypeChecker.INSTANCE, superFunctionSubstituted, function);
        if (!paramsOk || !returnTypeOk) {
            LOG.warn("Loaded Java method overrides another, but resolved as Kotlin function, doesn't.\nsuper function = " + superFunction + "\n" + "super class = " + superFunction.getContainingDeclaration() + "\n" + "sub function = " + function + "\n" + "sub class = " + function.getContainingDeclaration() + "\n" + "sub method = " + JavaSignatureFormatter.getInstance().getExternalName(method2) + "\n" + "@KotlinSignature = " + SignaturesUtil.getKotlinSignature(this.externalAnnotationResolver, method2));
        }
    }

    private static boolean containsErrorType(@NotNull List<FunctionDescriptor> superFunctions, @NotNull FunctionDescriptor function) {
        if (superFunctions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superFunctions", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "containsErrorType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "containsErrorType"));
        }
        if (ErrorUtils.containsErrorType(function)) {
            return true;
        }
        for (FunctionDescriptor superFunction : superFunctions) {
            if (!ErrorUtils.containsErrorType(superFunction)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMethodReturnTypeCompatible(@NotNull JavaMethodImpl method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "isMethodReturnTypeCompatible"));
        }
        if (method2.isStatic()) {
            return true;
        }
        HierarchicalMethodSignature methodSignature = ((PsiMethod)method2.getPsi()).getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
        PsiType returnType2 = methodSignature.getSubstitutor().substitute(((PsiMethod)method2.getPsi()).getReturnType());
        if (returnType2 == null) {
            return true;
        }
        for (HierarchicalMethodSignature superMethodSignature : superSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiType declaredReturnType = superMethod.getReturnType();
            PsiType superReturnType = superMethodSignature.isRaw() ? TypeConversionUtil.erasure(declaredReturnType) : declaredReturnType;
            if (superReturnType == null || method2 == superMethod || superMethod.getContainingClass() == null || PsiBasedMethodSignatureChecker.areMethodsReturnTypesCompatible(superMethodSignature, superReturnType, methodSignature, returnType2)) continue;
            return false;
        }
        return true;
    }

    private static boolean areMethodsReturnTypesCompatible(@NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull PsiType superReturnType, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType2) {
        PsiSubstitutor unifyingSubstitutor;
        if (superMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignature", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "areMethodsReturnTypesCompatible"));
        }
        if (superReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superReturnType", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "areMethodsReturnTypesCompatible"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "areMethodsReturnTypesCompatible"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "areMethodsReturnTypesCompatible"));
        }
        boolean isJdk15 = PsiUtil.isLanguageLevel5OrHigher(methodSignature.getMethod());
        PsiType substitutedSuperReturnType = isJdk15 && !superMethodSignature.isRaw() && superMethodSignature.equals(methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(methodSignature, superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure(superMethodSignature.getSubstitutor().substitute(superReturnType));
        if (returnType2.equals(substitutedSuperReturnType)) {
            return true;
        }
        return !(returnType2 instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && TypeConversionUtil.isAssignable(substitutedSuperReturnType, returnType2);
    }

    @Override
    public void checkSignature(@NotNull JavaMethod method2, boolean reportSignatureErrors, @NotNull SimpleFunctionDescriptor descriptor, @NotNull List<String> signatureErrors, @NotNull List<FunctionDescriptor> superFunctions) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "checkSignature"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "checkSignature"));
        }
        if (signatureErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "checkSignature"));
        }
        if (superFunctions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superFunctions", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker", "checkSignature"));
        }
        if (superFunctions.isEmpty() && (signatureErrors.isEmpty() || !reportSignatureErrors)) {
            return;
        }
        JavaMethodImpl methodWithPsi = (JavaMethodImpl)method2;
        if (!RawTypesCheck.hasRawTypesInHierarchicalSignature(methodWithPsi) && PsiBasedMethodSignatureChecker.isMethodReturnTypeCompatible(methodWithPsi) && !PsiBasedMethodSignatureChecker.containsErrorType(superFunctions, descriptor)) {
            if (signatureErrors.isEmpty()) {
                for (FunctionDescriptor superFunction : superFunctions) {
                    this.checkFunctionOverridesCorrectly(method2, descriptor, superFunction);
                }
            } else if (reportSignatureErrors) {
                this.externalSignatureResolver.reportSignatureErrors(descriptor, signatureErrors);
            }
        }
    }

    private static class RawTypesCheck {
        private static boolean isPartiallyRawType(@NotNull JavaType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker$RawTypesCheck", "isPartiallyRawType"));
            }
            if (type instanceof JavaPrimitiveType) {
                return false;
            }
            if (type instanceof JavaClassifierType) {
                JavaClassifierType classifierType = (JavaClassifierType)type;
                if (classifierType.isRaw()) {
                    return true;
                }
                for (JavaType argument : classifierType.getTypeArguments()) {
                    if (!RawTypesCheck.isPartiallyRawType(argument)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof JavaArrayType) {
                return RawTypesCheck.isPartiallyRawType(((JavaArrayType)type).getComponentType());
            }
            if (type instanceof JavaWildcardType) {
                JavaType bound = ((JavaWildcardType)type).getBound();
                return bound != null && RawTypesCheck.isPartiallyRawType(bound);
            }
            throw new IllegalStateException("Unexpected type: " + type);
        }

        private static boolean hasRawTypesInSignature(@NotNull JavaMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker$RawTypesCheck", "hasRawTypesInSignature"));
            }
            JavaType returnType2 = method2.getReturnType();
            if (returnType2 != null && RawTypesCheck.isPartiallyRawType(returnType2)) {
                return true;
            }
            for (JavaValueParameter parameter : method2.getValueParameters()) {
                if (!RawTypesCheck.isPartiallyRawType(parameter.getType())) continue;
                return true;
            }
            for (JavaTypeParameter typeParameter : method2.getTypeParameters()) {
                for (JavaClassifierType upperBound : typeParameter.getUpperBounds()) {
                    if (!RawTypesCheck.isPartiallyRawType(upperBound)) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean hasRawTypesInHierarchicalSignature(@NotNull JavaMethodImpl method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker$RawTypesCheck", "hasRawTypesInHierarchicalSignature"));
            }
            if (method2.isStatic()) {
                return false;
            }
            if (RawTypesCheck.hasRawTypesInSignature(method2)) {
                return true;
            }
            for (HierarchicalMethodSignature superSignature : ((PsiMethod)method2.getPsi()).getHierarchicalMethodSignature().getSuperSignatures()) {
                JavaMethodImpl superMethod = new JavaMethodImpl(superSignature.getMethod());
                if (!superSignature.isRaw() && !RawTypesCheck.typeParameterIsErased(method2, superMethod) && !RawTypesCheck.hasRawTypesInSignature(superMethod)) continue;
                return true;
            }
            return false;
        }

        private static boolean typeParameterIsErased(@NotNull JavaMethod method2, @NotNull JavaMethod superMethod) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker$RawTypesCheck", "typeParameterIsErased"));
            }
            if (superMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "org/jetbrains/jet/lang/resolve/java/resolver/PsiBasedMethodSignatureChecker$RawTypesCheck", "typeParameterIsErased"));
            }
            return method2.getTypeParameters().size() != superMethod.getTypeParameters().size();
        }

        private RawTypesCheck() {
        }
    }
}

