/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeFieldSignatureData;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeMethodSignatureData;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.types.JetType;

public class TraceBasedExternalSignatureResolver
implements ExternalSignatureResolver {
    private BindingTrace trace;
    private ExternalAnnotationResolver externalAnnotationResolver;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setExternalAnnotationResolver(ExternalAnnotationResolver externalAnnotationResolver) {
        this.externalAnnotationResolver = externalAnnotationResolver;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod method2, @NotNull ClassDescriptor owner, @NotNull JetType returnType2, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        SignaturesPropagationData data2 = new SignaturesPropagationData(owner, returnType2, receiverType, valueParameters, typeParameters, (JavaMethodImpl)method2, this.trace);
        ExternalSignatureResolver.PropagatedMethodSignature propagatedMethodSignature = new ExternalSignatureResolver.PropagatedMethodSignature(data2.getModifiedReturnType(), data2.getModifiedReceiverType(), data2.getModifiedValueParameters(), data2.getModifiedTypeParameters(), data2.getSignatureErrors(), data2.getSuperFunctions());
        if (propagatedMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolvePropagatedSignature"));
        }
        return propagatedMethodSignature;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMethod method2, boolean hasSuperMethods, @Nullable JetType returnType2, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        AlternativeMethodSignatureData data2 = new AlternativeMethodSignatureData(this.externalAnnotationResolver, (JavaMethodImpl)method2, receiverType, valueParameters, returnType2, typeParameters, hasSuperMethods);
        if (data2.isAnnotated() && !data2.hasErrors()) {
            ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(data2.getReturnType(), receiverType, data2.getValueParameters(), data2.getTypeParameters(), Collections.<String>emptyList());
            if (alternativeMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
            }
            return alternativeMethodSignature;
        }
        List<String> error = data2.hasErrors() ? Collections.singletonList(data2.getError()) : Collections.emptyList();
        ExternalSignatureResolver.AlternativeMethodSignature alternativeMethodSignature = new ExternalSignatureResolver.AlternativeMethodSignature(returnType2, receiverType, valueParameters, typeParameters, error);
        if (alternativeMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeMethodSignature"));
        }
        return alternativeMethodSignature;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField field, @NotNull JetType returnType2, boolean isVar) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        AlternativeFieldSignatureData data2 = new AlternativeFieldSignatureData(this.externalAnnotationResolver, (JavaFieldImpl)field, returnType2, isVar);
        if (data2.isAnnotated() && !data2.hasErrors()) {
            ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(data2.getReturnType(), null);
            if (alternativeFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
            }
            return alternativeFieldSignature;
        }
        String error = data2.hasErrors() ? data2.getError() : null;
        ExternalSignatureResolver.AlternativeFieldSignature alternativeFieldSignature = new ExternalSignatureResolver.AlternativeFieldSignature(returnType2, error);
        if (alternativeFieldSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "resolveAlternativeFieldSignature"));
        }
        return alternativeFieldSignature;
    }

    @Override
    public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor, @NotNull List<String> signatureErrors) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "reportSignatureErrors"));
        }
        if (signatureErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/jet/lang/resolve/java/resolver/TraceBasedExternalSignatureResolver", "reportSignatureErrors"));
        }
        this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor, signatureErrors);
    }
}

