/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DependencyKind;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.PackageType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.BuiltInsPackageMigration;
import org.jetbrains.jet.lang.types.lang.BuiltinsPackageFragment;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public class KotlinBuiltIns {
    public static final JetScope STUB = JetScope.EMPTY;
    public static final String BUILT_INS_PACKAGE_NAME_STRING = "jet";
    public static final Name BUILT_INS_PACKAGE_NAME = Name.identifier("jet");
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
    public static final int FUNCTION_TRAIT_COUNT = 23;
    private static volatile KotlinBuiltIns instance = null;
    private static volatile boolean initializing;
    private static Throwable initializationFailed;
    private final ModuleDescriptorImpl builtInsModule = new ModuleDescriptorImpl(Name.special("<built-ins lazy module>"), Collections.<ImportPath>emptyList(), PlatformToKotlinClassMap.EMPTY);
    private final BuiltinsPackageFragment builtinsPackageFragment = new BuiltinsPackageFragment(new LockBasedStorageManager(), this.builtInsModule);
    private volatile ImmutableSet<ClassDescriptor> nonPhysicalClasses;
    private final ImmutableSet<ClassDescriptor> functionClassesSet;
    private final ImmutableSet<ClassDescriptor> extensionFunctionClassesSet;
    private final EnumMap<PrimitiveType, ClassDescriptor> primitiveTypeToClass;
    private final EnumMap<PrimitiveType, ClassDescriptor> primitiveTypeToArrayClass;
    private final EnumMap<PrimitiveType, JetType> primitiveTypeToJetType;
    private final EnumMap<PrimitiveType, JetType> primitiveTypeToNullableJetType;
    private final EnumMap<PrimitiveType, JetType> primitiveTypeToArrayJetType;
    private final Map<JetType, JetType> primitiveJetTypeToJetArrayType;
    private final Map<JetType, JetType> jetArrayTypeToPrimitiveJetType;
    private final ClassDescriptor nothingClass;
    private final ClassDescriptor arrayClass;
    private final ClassDescriptor deprecatedAnnotationClass;
    private final ClassDescriptor dataAnnotationClass;
    private final ClassDescriptor[] functionClasses;
    private volatile JetType anyType;
    private volatile JetType nullableAnyType;
    private volatile JetType nothingType;
    private volatile JetType nullableNothingType;
    private volatile JetType unitType;
    private volatile JetType stringType;
    private volatile JetType annotationType;

    private static synchronized void initialize() {
        if (instance == null) {
            if (initializationFailed != null) {
                throw new RuntimeException("builtin library initialization failed previously: " + initializationFailed, initializationFailed);
            }
            if (initializing) {
                throw new IllegalStateException("builtin library initialization loop");
            }
            initializing = true;
            try {
                instance = new KotlinBuiltIns();
                instance.doInitialize();
            }
            catch (Throwable e) {
                initializationFailed = e;
                throw new RuntimeException("builtin library initialization failed: " + e, e);
            }
            finally {
                initializing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static KotlinBuiltIns getInstance() {
        if (initializing) {
            Class<KotlinBuiltIns> clazz = KotlinBuiltIns.class;
            synchronized (KotlinBuiltIns.class) {
                assert (instance != null) : "Built-ins are not initialized (note: We are under the same lock as initializing and instance)";
                KotlinBuiltIns kotlinBuiltIns = instance;
                // ** MonitorExit[var0] (shouldn't be in output)
                if (kotlinBuiltIns == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getInstance"));
                }
                return kotlinBuiltIns;
            }
        }
        if (instance == null) {
            KotlinBuiltIns.initialize();
        }
        KotlinBuiltIns kotlinBuiltIns = instance;
        if (kotlinBuiltIns == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getInstance"));
        }
        return kotlinBuiltIns;
    }

    private KotlinBuiltIns() {
        this.builtInsModule.addFragmentProvider(DependencyKind.SOURCES, this.builtinsPackageFragment.getProvider());
        this.functionClassesSet = this.computeIndexedClasses("Function", 23);
        this.extensionFunctionClassesSet = this.computeIndexedClasses("ExtensionFunction", 23);
        this.primitiveTypeToClass = new EnumMap(PrimitiveType.class);
        this.primitiveTypeToJetType = new EnumMap(PrimitiveType.class);
        this.primitiveTypeToNullableJetType = new EnumMap(PrimitiveType.class);
        this.primitiveTypeToArrayClass = new EnumMap(PrimitiveType.class);
        this.primitiveTypeToArrayJetType = new EnumMap(PrimitiveType.class);
        this.primitiveJetTypeToJetArrayType = new HashMap<JetType, JetType>();
        this.jetArrayTypeToPrimitiveJetType = new HashMap<JetType, JetType>();
        this.nothingClass = this.getBuiltInClassByName("Nothing");
        this.arrayClass = this.getBuiltInClassByName("Array");
        this.deprecatedAnnotationClass = this.getBuiltInClassByName("deprecated");
        this.dataAnnotationClass = this.getBuiltInClassByName("data");
        this.functionClasses = new ClassDescriptor[23];
        for (int i = 0; i < this.functionClasses.length; ++i) {
            this.functionClasses[i] = this.getBuiltInClassByName("Function" + i);
        }
    }

    private void doInitialize() {
        this.anyType = this.getBuiltInTypeByClassName("Any");
        this.nullableAnyType = TypeUtils.makeNullable(this.anyType);
        this.nothingType = this.getBuiltInTypeByClassName("Nothing");
        this.nullableNothingType = TypeUtils.makeNullable(this.nothingType);
        this.unitType = this.getBuiltInTypeByClassName("Unit");
        this.stringType = this.getBuiltInTypeByClassName("String");
        this.annotationType = this.getBuiltInTypeByClassName("Annotation");
        for (PrimitiveType primitive : PrimitiveType.values()) {
            this.makePrimitive(primitive);
        }
        this.nonPhysicalClasses = this.computeNonPhysicalClasses();
    }

    private void makePrimitive(PrimitiveType primitiveType) {
        ClassDescriptor theClass = this.getBuiltInClassByName(primitiveType.getTypeName().asString());
        JetTypeImpl type = new JetTypeImpl(theClass);
        ClassDescriptor arrayClass = this.getBuiltInClassByName(primitiveType.getArrayTypeName().asString());
        JetTypeImpl arrayType = new JetTypeImpl(arrayClass);
        this.primitiveTypeToClass.put(primitiveType, theClass);
        this.primitiveTypeToJetType.put(primitiveType, type);
        this.primitiveTypeToNullableJetType.put(primitiveType, TypeUtils.makeNullable(type));
        this.primitiveTypeToArrayClass.put(primitiveType, arrayClass);
        this.primitiveTypeToArrayJetType.put(primitiveType, arrayType);
        this.primitiveJetTypeToJetArrayType.put(type, arrayType);
        this.jetArrayTypeToPrimitiveJetType.put(arrayType, type);
    }

    @NotNull
    public ModuleDescriptorImpl getBuiltInsModule() {
        ModuleDescriptorImpl moduleDescriptorImpl = this.builtInsModule;
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInsModule"));
        }
        return moduleDescriptorImpl;
    }

    @NotNull
    public PackageFragmentDescriptor getBuiltInsPackageFragment() {
        BuiltinsPackageFragment builtinsPackageFragment = this.builtinsPackageFragment;
        if (builtinsPackageFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInsPackageFragment"));
        }
        return builtinsPackageFragment;
    }

    @NotNull
    public JetScope getBuiltInsPackageScope() {
        JetScope jetScope = this.builtinsPackageFragment.getMemberScope();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInsPackageScope"));
        }
        return jetScope;
    }

    @NotNull
    public ClassDescriptor getBuiltInClassByName(@NotNull Name simpleName) {
        if (simpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        ClassifierDescriptor classifier2 = this.getBuiltInsPackageFragment().getMemberScope().getClassifier(simpleName);
        assert (classifier2 instanceof ClassDescriptor) : "Must be a class descriptor " + simpleName + ", but was " + classifier2;
        ClassDescriptor classDescriptor = (ClassDescriptor)classifier2;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        return classDescriptor;
    }

    @NotNull
    private ClassDescriptor getBuiltInClassByName(@NotNull String simpleName) {
        if (simpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(Name.identifier(simpleName));
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInClassByName"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getAny() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Any");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAny"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getNothing() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Nothing");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNothing"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getPrimitiveClassDescriptor(@NotNull PrimitiveType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveClassDescriptor"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(type.getTypeName().asString());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getByte() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.BYTE);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getByte"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getShort() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.SHORT);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getShort"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getInt() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.INT);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getInt"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getLong() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.LONG);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getLong"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getFloat() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.FLOAT);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFloat"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getDouble() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.DOUBLE);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDouble"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getChar() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.CHAR);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getChar"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getBoolean() {
        ClassDescriptor classDescriptor = this.getPrimitiveClassDescriptor(PrimitiveType.BOOLEAN);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBoolean"));
        }
        return classDescriptor;
    }

    @NotNull
    public Set<DeclarationDescriptor> getIntegralRanges() {
        ImmutableSet<DeclarationDescriptor> immutableSet = ImmutableSet.of(this.getBuiltInClassByName("ByteRange"), this.getBuiltInClassByName("ShortRange"), this.getBuiltInClassByName("CharRange"), this.getBuiltInClassByName("IntRange"));
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getIntegralRanges"));
        }
        return immutableSet;
    }

    @NotNull
    public ClassDescriptor getArray() {
        if (BuiltInsPackageMigration.isSerializingBuiltInsInKotlinPackage) {
            ClassDescriptor classDescriptor = BuiltInsPackageMigration.arrayClass;
            if (classDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArray"));
            }
            return classDescriptor;
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Array");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArray"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getPrimitiveArrayClassDescriptor(@NotNull PrimitiveType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayClassDescriptor"));
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName(type.getArrayTypeName().asString());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getNumber() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Number");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNumber"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getHashable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Hashable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getHashable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getUnit() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Unit");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getUnit"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getFunction(int parameterCount) {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Function" + parameterCount);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getExtensionFunction(int parameterCount) {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("ExtensionFunction" + parameterCount);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getExtensionFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getKFunction(int parameterCount) {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("KFunction" + parameterCount);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getKFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getKMemberFunction(int parameterCount) {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("KMemberFunction" + parameterCount);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getKMemberFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getKExtensionFunction(int parameterCount) {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("KExtensionFunction" + parameterCount);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getKExtensionFunction"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getThrowable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Throwable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getThrowable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getDataClassAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("data");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDataClassAnnotation"));
        }
        return classDescriptor;
    }

    public ClassDescriptor getNoinlineClassAnnotation() {
        return this.getBuiltInClassByName("noinline");
    }

    @NotNull
    public ClassDescriptor getInlineClassAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("inline");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getInlineClassAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getSuppressAnnotationClass() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("suppress");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getSuppressAnnotationClass"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getVolatileAnnotationClass() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("volatile");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getVolatileAnnotationClass"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getTailRecursiveAnnotationClass() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("tailRecursive");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getTailRecursiveAnnotationClass"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getDeprecatedAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("deprecated");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDeprecatedAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getString() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("String");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getString"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getCharSequence() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("CharSequence");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCharSequence"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getComparable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Comparable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getComparable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getEnum() {
        if (BuiltInsPackageMigration.isSerializingBuiltInsInKotlinPackage) {
            ClassDescriptor classDescriptor = BuiltInsPackageMigration.enumClass;
            if (classDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getEnum"));
            }
            return classDescriptor;
        }
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Enum");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getEnum"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getAnnotation() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Annotation");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAnnotation"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Iterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getIterable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Iterable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getIterable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableIterable() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableIterable");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableIterable"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableIterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getCollection() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Collection");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCollection"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableCollection() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableCollection");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableCollection"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getList() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("List");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getList"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableList() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableList");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableList"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getSet() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Set");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getSet"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableSet() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableSet");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableSet"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMap() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("Map");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMap"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableMap() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableMap");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableMap"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getBuiltInClassByName("Map"), "Entry");
        assert (classDescriptor != null) : "Can't find Map.Entry";
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMapEntry"));
        }
        return classDescriptor2;
    }

    @NotNull
    public ClassDescriptor getMutableMapEntry() {
        ClassDescriptor classDescriptor = DescriptorUtils.getInnerClassByName(this.getBuiltInClassByName("MutableMap"), "MutableEntry");
        assert (classDescriptor != null) : "Can't find MutableMap.MutableEntry";
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableMapEntry"));
        }
        return classDescriptor2;
    }

    @NotNull
    public ClassDescriptor getListIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("ListIterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getListIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getMutableListIterator() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("MutableListIterator");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getMutableListIterator"));
        }
        return classDescriptor;
    }

    @NotNull
    public Set<ClassDescriptor> getNonPhysicalClasses() {
        ImmutableSet<ClassDescriptor> immutableSet = this.nonPhysicalClasses;
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNonPhysicalClasses"));
        }
        return immutableSet;
    }

    @NotNull
    private ImmutableSet<ClassDescriptor> computeNonPhysicalClasses() {
        ImmutableSet.Builder<ClassDescriptor> nonPhysical = ImmutableSet.builder();
        nonPhysical.add(this.getAny(), this.getNothing(), this.getNumber(), this.getString(), this.getCharSequence(), this.getThrowable(), this.getBuiltInClassByName("Hashable"), this.getIterator(), this.getIterable(), this.getCollection(), this.getList(), this.getListIterator(), this.getSet(), this.getMap(), this.getMapEntry(), this.getMutableIterator(), this.getMutableIterable(), this.getMutableCollection(), this.getMutableList(), this.getMutableListIterator(), this.getMutableSet(), this.getMutableMap(), this.getMutableMapEntry(), this.getVolatileAnnotationClass(), this.getDataClassAnnotation(), this.getAnnotation(), this.getComparable(), this.getEnum(), this.getArray());
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            nonPhysical.add(this.getPrimitiveClassDescriptor(primitiveType));
            nonPhysical.add(this.getPrimitiveArrayClassDescriptor(primitiveType));
        }
        ImmutableSet<ClassDescriptor> immutableSet = nonPhysical.build();
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "computeNonPhysicalClasses"));
        }
        return immutableSet;
    }

    @NotNull
    private JetType getBuiltInTypeByClassName(@NotNull String classSimpleName) {
        if (classSimpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classSimpleName", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInTypeByClassName"));
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(this.getBuiltInClassByName(classSimpleName));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBuiltInTypeByClassName"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public JetType getNothingType() {
        JetType jetType = this.getBuiltInTypeByClassName("Nothing");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNothingType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getNullableNothingType() {
        JetType jetType = TypeUtils.makeNullable(this.getNothingType());
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNullableNothingType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getAnyType() {
        if (BuiltInsPackageMigration.isSerializingBuiltInsInKotlinPackage) {
            JetType jetType = BuiltInsPackageMigration.anyType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAnyType"));
            }
            return jetType;
        }
        JetType jetType = this.getBuiltInTypeByClassName("Any");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAnyType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getNullableAnyType() {
        JetType jetType = TypeUtils.makeNullable(this.getAnyType());
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNullableAnyType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getPrimitiveJetType(@NotNull PrimitiveType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveJetType"));
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(this.getPrimitiveClassDescriptor(type));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveJetType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public JetType getNullablePrimitiveJetType(@NotNull PrimitiveType primitiveType) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNullablePrimitiveJetType"));
        }
        JetType jetType = this.primitiveTypeToNullableJetType.get((Object)primitiveType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getNullablePrimitiveJetType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getByteType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.BYTE);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getByteType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getShortType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.SHORT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getShortType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getIntType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.INT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getIntType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getLongType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.LONG);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getLongType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getFloatType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.FLOAT);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFloatType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getDoubleType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.DOUBLE);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDoubleType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getCharType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.CHAR);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCharType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getBooleanType() {
        JetType jetType = this.getPrimitiveJetType(PrimitiveType.BOOLEAN);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getBooleanType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getUnitType() {
        JetType jetType = this.getBuiltInTypeByClassName("Unit");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getUnitType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getStringType() {
        if (BuiltInsPackageMigration.isSerializingBuiltInsInKotlinPackage) {
            JetType jetType = BuiltInsPackageMigration.stringType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getStringType"));
            }
            return jetType;
        }
        JetType jetType = this.getBuiltInTypeByClassName("String");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getStringType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getArrayElementType(@NotNull JetType arrayType) {
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayElementType"));
        }
        if (arrayType.getConstructor().getDeclarationDescriptor() == this.getArray()) {
            if (arrayType.getArguments().size() != 1) {
                throw new IllegalStateException();
            }
            JetType jetType = arrayType.getArguments().get(0).getType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayElementType"));
            }
            return jetType;
        }
        JetType primitiveType = this.jetArrayTypeToPrimitiveJetType.get(TypeUtils.makeNotNullable(arrayType));
        if (primitiveType == null) {
            throw new IllegalStateException("not array: " + arrayType);
        }
        JetType jetType = primitiveType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayElementType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getPrimitiveArrayJetType(@NotNull PrimitiveType primitiveType) {
        if (primitiveType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitiveType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayJetType"));
        }
        JetType jetType = this.primitiveTypeToArrayJetType.get((Object)primitiveType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayJetType"));
        }
        return jetType;
    }

    @Nullable
    public JetType getPrimitiveArrayJetTypeByPrimitiveJetType(@NotNull JetType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPrimitiveArrayJetTypeByPrimitiveJetType"));
        }
        return this.primitiveJetTypeToJetArrayType.get(jetType);
    }

    @NotNull
    public JetType getArrayType(@NotNull Variance projectionType, @NotNull JetType argument) {
        if (projectionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        List<TypeProjectionImpl> types = Collections.singletonList(new TypeProjectionImpl(projectionType, argument));
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Annotations.EMPTY, this.getArray().getTypeConstructor(), false, types, this.getArray().getMemberScope(types));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public JetType getArrayType(@NotNull JetType argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        JetType jetType = this.getArrayType(Variance.INVARIANT, argument);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getArrayType"));
        }
        return jetType;
    }

    @NotNull
    public JetType getEnumType(@NotNull JetType argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getEnumType"));
        }
        Variance projectionType = Variance.INVARIANT;
        List<TypeProjectionImpl> types = Collections.singletonList(new TypeProjectionImpl(projectionType, argument));
        JetTypeImpl jetTypeImpl = new JetTypeImpl(Annotations.EMPTY, this.getEnum().getTypeConstructor(), false, types, this.getEnum().getMemberScope(types));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getEnumType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public JetType getAnnotationType() {
        if (BuiltInsPackageMigration.isSerializingBuiltInsInKotlinPackage) {
            JetType jetType = BuiltInsPackageMigration.annotationType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAnnotationType"));
            }
            return jetType;
        }
        JetType jetType = this.getBuiltInTypeByClassName("Annotation");
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getAnnotationType"));
        }
        return jetType;
    }

    @NotNull
    public ClassDescriptor getPropertyMetadata() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("PropertyMetadata");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPropertyMetadata"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor getPropertyMetadataImpl() {
        ClassDescriptor classDescriptor = this.getBuiltInClassByName("PropertyMetadataImpl");
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getPropertyMetadataImpl"));
        }
        return classDescriptor;
    }

    @NotNull
    public JetType getFunctionType(@NotNull Annotations annotations, @Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType2) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionType"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionType"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionType"));
        }
        List<TypeProjection> arguments2 = KotlinBuiltIns.getFunctionTypeArgumentProjections(receiverType, parameterTypes, returnType2);
        int size = parameterTypes.size();
        ClassDescriptor classDescriptor = receiverType == null ? this.getFunction(size) : this.getExtensionFunction(size);
        TypeConstructor constructor = classDescriptor.getTypeConstructor();
        JetTypeImpl jetTypeImpl = new JetTypeImpl(annotations, constructor, false, arguments2, classDescriptor.getMemberScope(arguments2));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    public JetType getKFunctionType(@NotNull Annotations annotations, @Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType2, boolean extensionFunction) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getKFunctionType"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getKFunctionType"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getKFunctionType"));
        }
        List<TypeProjection> arguments2 = KotlinBuiltIns.getFunctionTypeArgumentProjections(receiverType, parameterTypes, returnType2);
        ClassDescriptor classDescriptor = this.getCorrespondingKFunctionClass(receiverType, extensionFunction, parameterTypes.size());
        JetTypeImpl jetTypeImpl = new JetTypeImpl(annotations, classDescriptor.getTypeConstructor(), false, arguments2, classDescriptor.getMemberScope(arguments2));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getKFunctionType"));
        }
        return jetTypeImpl;
    }

    @NotNull
    private ClassDescriptor getCorrespondingKFunctionClass(@Nullable JetType receiverType, boolean extensionFunction, int numberOfParameters) {
        if (receiverType == null) {
            ClassDescriptor classDescriptor = this.getKFunction(numberOfParameters);
            if (classDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCorrespondingKFunctionClass"));
            }
            return classDescriptor;
        }
        if (extensionFunction) {
            ClassDescriptor classDescriptor = this.getKExtensionFunction(numberOfParameters);
            if (classDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCorrespondingKFunctionClass"));
            }
            return classDescriptor;
        }
        ClassDescriptor classDescriptor = this.getKMemberFunction(numberOfParameters);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getCorrespondingKFunctionClass"));
        }
        return classDescriptor;
    }

    @NotNull
    private static List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType2) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionTypeArgumentProjections"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionTypeArgumentProjections"));
        }
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>();
        if (receiverType != null) {
            arguments2.add(KotlinBuiltIns.defaultProjection(receiverType));
        }
        for (JetType parameterType : parameterTypes) {
            arguments2.add(KotlinBuiltIns.defaultProjection(parameterType));
        }
        arguments2.add(KotlinBuiltIns.defaultProjection(returnType2));
        ArrayList<TypeProjection> arrayList = arguments2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getFunctionTypeArgumentProjections"));
        }
        return arrayList;
    }

    private static TypeProjection defaultProjection(JetType returnType2) {
        return new TypeProjectionImpl(Variance.INVARIANT, returnType2);
    }

    public boolean isArray(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isArray"));
        }
        return this.getArray().equals(type.getConstructor().getDeclarationDescriptor());
    }

    public boolean isPrimitiveArray(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isPrimitiveArray"));
        }
        return this.jetArrayTypeToPrimitiveJetType.containsKey(TypeUtils.makeNotNullable(type));
    }

    public boolean isPrimitiveType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isPrimitiveType"));
        }
        return this.primitiveJetTypeToJetArrayType.containsKey(type);
    }

    @NotNull
    private ImmutableSet<ClassDescriptor> computeIndexedClasses(@NotNull String prefix, int count) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "computeIndexedClasses"));
        }
        ImmutableSet.Builder<ClassDescriptor> builder = ImmutableSet.builder();
        for (int i = 0; i < count; ++i) {
            builder.add(this.getBuiltInClassByName(prefix + i));
        }
        ImmutableSet<ClassDescriptor> immutableSet = builder.build();
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "computeIndexedClasses"));
        }
        return immutableSet;
    }

    public boolean isFunctionOrExtensionFunctionType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isFunctionOrExtensionFunctionType"));
        }
        return this.isFunctionType(type) || this.isExtensionFunctionType(type);
    }

    public boolean isFunctionType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isFunctionType"));
        }
        if (KotlinBuiltIns.setContainsClassOf(this.functionClassesSet, type)) {
            return true;
        }
        for (JetType superType : type.getConstructor().getSupertypes()) {
            if (!this.isFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    public boolean isExactFunctionOrExtensionFunctionType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isExactFunctionOrExtensionFunctionType"));
        }
        return KotlinBuiltIns.setContainsClassOf(this.extensionFunctionClassesSet, type) || KotlinBuiltIns.setContainsClassOf(this.functionClassesSet, type);
    }

    public boolean isExtensionFunctionType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isExtensionFunctionType"));
        }
        if (KotlinBuiltIns.setContainsClassOf(this.extensionFunctionClassesSet, type)) {
            return true;
        }
        for (JetType superType : type.getConstructor().getSupertypes()) {
            if (!this.isExtensionFunctionType(superType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public JetType getReceiverType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getReceiverType"));
        }
        assert (this.isFunctionOrExtensionFunctionType(type)) : type;
        if (this.isExtensionFunctionType(type)) {
            return type.getArguments().get(0).getType();
        }
        return null;
    }

    @NotNull
    public List<ValueParameterDescriptor> getValueParameters(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetType type) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getValueParameters"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getValueParameters"));
        }
        assert (this.isFunctionOrExtensionFunctionType(type));
        ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
        List<TypeProjection> parameterTypes = this.getParameterTypeProjectionsFromFunctionType(type);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeProjection parameterType = parameterTypes.get(i);
            ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, i, Annotations.EMPTY, Name.identifier("p" + (i + 1)), parameterType.getType(), false, null);
            valueParameters.add(valueParameterDescriptor);
        }
        ArrayList<ValueParameterDescriptor> arrayList = valueParameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getValueParameters"));
        }
        return arrayList;
    }

    @NotNull
    public JetType getReturnTypeFromFunctionType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getReturnTypeFromFunctionType"));
        }
        assert (this.isFunctionOrExtensionFunctionType(type));
        List<TypeProjection> arguments2 = type.getArguments();
        JetType jetType = arguments2.get(arguments2.size() - 1).getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getReturnTypeFromFunctionType"));
        }
        return jetType;
    }

    @NotNull
    public List<TypeProjection> getParameterTypeProjectionsFromFunctionType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getParameterTypeProjectionsFromFunctionType"));
        }
        assert (this.isFunctionOrExtensionFunctionType(type));
        List<TypeProjection> arguments2 = type.getArguments();
        int first = this.isExtensionFunctionType(type) ? 1 : 0;
        int last = arguments2.size() - 2;
        ArrayList<TypeProjection> parameterTypes = Lists.newArrayList();
        for (int i = first; i <= last; ++i) {
            parameterTypes.add(arguments2.get(i));
        }
        ArrayList<TypeProjection> arrayList = parameterTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getParameterTypeProjectionsFromFunctionType"));
        }
        return arrayList;
    }

    public static boolean isSpecialClassWithNoSupertypes(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isSpecialClassWithNoSupertypes"));
        }
        FqNameUnsafe fqName = DescriptorUtils.getFqName(descriptor);
        return BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("Any")).toUnsafe().equals(fqName) || BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("Nothing")).toUnsafe().equals(fqName);
    }

    public boolean isNothing(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isNothing"));
        }
        return this.isNothingOrNullableNothing(type) && !type.isNullable();
    }

    public boolean isNullableNothing(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isNullableNothing"));
        }
        return this.isNothingOrNullableNothing(type) && type.isNullable();
    }

    public boolean isNothingOrNullableNothing(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isNothingOrNullableNothing"));
        }
        return !(type instanceof PackageType) && type.getConstructor() == this.getNothing().getTypeConstructor();
    }

    public boolean isAnyOrNullableAny(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isAnyOrNullableAny"));
        }
        return !(type instanceof PackageType) && type.getConstructor() == this.getAny().getTypeConstructor();
    }

    public boolean isUnit(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isUnit"));
        }
        return !(type instanceof PackageType) && ((Object)type).equals(this.getUnitType());
    }

    public boolean isData(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isData"));
        }
        return KotlinBuiltIns.containsAnnotation(classDescriptor, this.getDataClassAnnotation());
    }

    public boolean isDeprecated(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isDeprecated"));
        }
        return KotlinBuiltIns.containsAnnotation(declarationDescriptor, this.getDeprecatedAnnotation());
    }

    public boolean isTailRecursive(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isTailRecursive"));
        }
        return KotlinBuiltIns.containsAnnotation(declarationDescriptor, this.getTailRecursiveAnnotationClass());
    }

    static boolean containsAnnotation(DeclarationDescriptor descriptor, ClassDescriptor annotationClass) {
        FqName fqName = DescriptorUtils.getFqName(annotationClass).toSafe();
        return descriptor.getOriginal().getAnnotations().findAnnotation(fqName) != null;
    }

    public boolean isVolatile(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "isVolatile"));
        }
        return KotlinBuiltIns.containsAnnotation(descriptor, this.getVolatileAnnotationClass());
    }

    @NotNull
    public JetType getDefaultBound() {
        JetType jetType = this.getNullableAnyType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/KotlinBuiltIns", "getDefaultBound"));
        }
        return jetType;
    }

    private static boolean setContainsClassOf(ImmutableSet<ClassDescriptor> set, JetType type) {
        return set.contains(type.getConstructor().getDeclarationDescriptor());
    }
}

