/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.k2js.translate.reference.ClassObjectAccessTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceAccessTranslator;
import org.jetbrains.k2js.translate.reference.VariableAccessTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class ReferenceTranslator {
    private ReferenceTranslator() {
    }

    @NotNull
    public static JsExpression translateSimpleName(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateSimpleName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateSimpleName"));
        }
        JsExpression jsExpression = ReferenceTranslator.getAccessTranslator(expression, context).translateAsGet();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateSimpleName"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsFQReference(@NotNull DeclarationDescriptor referencedDescriptor, @NotNull TranslationContext context) {
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsFQReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsFQReference"));
        }
        JsExpression alias = context.getAliasForDescriptor(referencedDescriptor);
        JsExpression jsExpression = alias != null ? alias : context.getQualifiedReference(referencedDescriptor);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsFQReference"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsLocalNameReference(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context) {
        JsExpression alias;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsLocalNameReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsLocalNameReference"));
        }
        if ((descriptor instanceof FunctionDescriptor || descriptor instanceof VariableDescriptor) && (alias = context.getAliasForDescriptor(descriptor)) != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsLocalNameReference"));
            }
            return jsExpression;
        }
        JsNameRef jsNameRef = context.getNameForDescriptor(descriptor).makeRef();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsLocalNameReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetSimpleNameExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        AccessTranslator accessTranslator = ReferenceTranslator.getAccessTranslator(referenceExpression, null, context);
        if (accessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        return accessTranslator;
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetSimpleNameExpression referenceExpression, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        if (JetPsiUtil.isBackingFieldReference(referenceExpression)) {
            BackingFieldAccessTranslator backingFieldAccessTranslator = BackingFieldAccessTranslator.newInstance(referenceExpression, context);
            if (backingFieldAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
            }
            return backingFieldAccessTranslator;
        }
        if (ReferenceTranslator.canBePropertyAccess(referenceExpression, context)) {
            VariableAccessTranslator variableAccessTranslator = VariableAccessTranslator.newInstance(context, referenceExpression, receiver);
            if (variableAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
            }
            return variableAccessTranslator;
        }
        if (ClassObjectAccessTranslator.isClassObjectReference(referenceExpression, context)) {
            ClassObjectAccessTranslator classObjectAccessTranslator = ClassObjectAccessTranslator.newInstance(referenceExpression, context);
            if (classObjectAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
            }
            return classObjectAccessTranslator;
        }
        ReferenceAccessTranslator referenceAccessTranslator = ReferenceAccessTranslator.newInstance(referenceExpression, context);
        if (referenceAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        return referenceAccessTranslator;
    }

    public static boolean canBePropertyAccess(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "canBePropertyAccess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "canBePropertyAccess"));
        }
        JetSimpleNameExpression simpleNameExpression = null;
        if (expression instanceof JetQualifiedExpression) {
            simpleNameExpression = PsiUtils.getSelectorAsSimpleName((JetQualifiedExpression)expression);
        } else if (expression instanceof JetSimpleNameExpression) {
            simpleNameExpression = (JetSimpleNameExpression)expression;
        }
        return simpleNameExpression != null && BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), simpleNameExpression) instanceof PropertyDescriptor;
    }
}

