/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.k2js.translate.callTranslator.CallTranslator;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public class VariableAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    private final ResolvedCall<? extends VariableDescriptor> resolvedCall;
    private final JsExpression receiver;

    public static VariableAccessTranslator newInstance(@NotNull TranslationContext context, @NotNull JetReferenceExpression referenceExpression, @Nullable JsExpression receiver) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator", "newInstance"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator", "newInstance"));
        }
        ResolvedCall<?> resolvedCall = BindingUtils.getResolvedCallForProperty(context.bindingContext(), referenceExpression);
        assert (resolvedCall.getResultingDescriptor() instanceof VariableDescriptor);
        return new VariableAccessTranslator(context, resolvedCall, receiver);
    }

    private VariableAccessTranslator(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall, @Nullable JsExpression receiver) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator", "<init>"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator", "<init>"));
        }
        super(context);
        this.receiver = receiver;
        this.resolvedCall = resolvedCall;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = CallTranslator.instance$.translateGet(this.context(), this.resolvedCall, this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator", "translateAsGet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        if (setTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setTo", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator", "translateAsSet"));
        }
        JsExpression jsExpression = CallTranslator.instance$.translateSet(this.context(), this.resolvedCall, setTo, this.receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator", "translateAsSet"));
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        TemporaryVariable temporaryVariable = this.receiver == null ? null : this.context().declareTemporary(this.receiver);
        CachedVariableAccessTranslator cachedVariableAccessTranslator = new CachedVariableAccessTranslator(this.context(), this.resolvedCall, temporaryVariable);
        if (cachedVariableAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator", "getCached"));
        }
        return cachedVariableAccessTranslator;
    }

    private static class CachedVariableAccessTranslator
    extends VariableAccessTranslator
    implements CachedAccessTranslator {
        @Nullable
        private final TemporaryVariable cachedReceiver;

        public CachedVariableAccessTranslator(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall, @Nullable TemporaryVariable cachedReceiver) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator", "<init>"));
            }
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator", "<init>"));
            }
            super(context, resolvedCall, cachedReceiver == null ? null : cachedReceiver.reference());
            this.cachedReceiver = cachedReceiver;
        }

        @Override
        @NotNull
        public List<TemporaryVariable> declaredTemporaries() {
            List<TemporaryVariable> list2 = this.cachedReceiver == null ? Collections.emptyList() : Collections.singletonList(this.cachedReceiver);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator", "declaredTemporaries"));
            }
            return list2;
        }

        @Override
        @NotNull
        public CachedAccessTranslator getCached() {
            CachedVariableAccessTranslator cachedVariableAccessTranslator = this;
            if (cachedVariableAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator", "getCached"));
            }
            return cachedVariableAccessTranslator;
        }
    }
}

