/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class JsFunction
extends JsLiteral
implements HasName {
    private JsBlock body;
    private List<JsParameter> params;
    private final JsScope scope;
    private JsName name;

    public JsFunction(JsScope parentScope) {
        this(parentScope, (JsName)null);
    }

    public JsFunction(JsScope parentScope, JsBlock body) {
        this(parentScope, (JsName)null);
        this.body = body;
    }

    private JsFunction(JsScope parentScope, @Nullable JsName name) {
        this.name = name;
        this.scope = new JsScope(parentScope, name == null ? null : name.getIdent());
    }

    public JsBlock getBody() {
        return this.body;
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    public List<JsParameter> getParameters() {
        if (this.params == null) {
            this.params = new SmartList<JsParameter>();
        }
        return this.params;
    }

    public JsScope getScope() {
        return this.scope;
    }

    public void setBody(JsBlock body) {
        this.body = body;
    }

    public void setName(@Nullable JsName name) {
        this.name = name;
    }

    @Override
    public void traverse(JsVisitor v, JsContext context) {
        if (v.visit(this, context)) {
            v.acceptWithInsertRemove(this.params);
            this.body = v.accept(this.body);
        }
        v.endVisit(this, context);
    }
}

