/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class InjectedSelfElementInfo
extends SelfElementInfo {
    private final SmartPsiFileRange myInjectedFileRangeInHostFile;
    private final Class<? extends PsiElement> anchorClass;
    private final Language anchorLanguage;

    InjectedSelfElementInfo(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement hostContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (hostContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        super(project, hostContext);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project);
        TextRange range = InjectedLanguageManager.getInstance(project).injectedToHost(element, element.getTextRange());
        this.myInjectedFileRangeInHostFile = smartPointerManager.createSmartPsiFileRangePointer(hostContext.getContainingFile(), range);
        this.anchorClass = element.getClass();
        this.anchorLanguage = element.getContainingFile().getLanguage();
    }

    @Override
    public VirtualFile getVirtualFile() {
        PsiElement element = this.restoreElement();
        if (element == null) {
            return null;
        }
        return element.getContainingFile().getVirtualFile();
    }

    @Override
    public PsiElement restoreElement() {
        Ref result;
        block6: {
            PsiLanguageInjectionHost.InjectedPsiVisitor visitor;
            PsiElement hostContext;
            block5: {
                hostContext = super.restoreElement();
                if (hostContext == null) {
                    return null;
                }
                Segment segment = this.myInjectedFileRangeInHostFile.getRange();
                if (segment == null) {
                    return null;
                }
                final TextRange rangeInHostFile = TextRange.create(segment);
                result = new Ref();
                final InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.getProject());
                PsiFile hostFile = hostContext.getContainingFile();
                if (hostFile == null) {
                    return null;
                }
                visitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                    @Override
                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                        if (injectedPsi == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo$1", "visit"));
                        }
                        if (places == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo$1", "visit"));
                        }
                        if (result.get() != null) {
                            return;
                        }
                        TextRange hostRange = manager.injectedToHost(injectedPsi, new TextRange(0, injectedPsi.getTextLength()));
                        Document document = PsiDocumentManager.getInstance(InjectedSelfElementInfo.this.getProject()).getDocument(injectedPsi);
                        if (hostRange.contains(rangeInHostFile) && document instanceof DocumentWindow) {
                            int start = ((DocumentWindow)document).hostToInjected(rangeInHostFile.getStartOffset());
                            int end = ((DocumentWindow)document).hostToInjected(rangeInHostFile.getEndOffset());
                            PsiElement element = SelfElementInfo.findElementInside(injectedPsi, start, end, InjectedSelfElementInfo.this.anchorClass, InjectedSelfElementInfo.this.anchorLanguage);
                            result.set(element);
                        }
                    }
                };
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.getProject());
                Document document = documentManager.getDocument(hostFile);
                if (document == null || !documentManager.isUncommited(document)) break block5;
                for (DocumentWindow documentWindow : InjectedLanguageManager.getInstance(this.getProject()).getCachedInjectedDocuments(hostFile)) {
                    PsiFile injected = documentManager.getPsiFile(documentWindow);
                    if (injected == null) continue;
                    visitor.visit(injected, Collections.<PsiLanguageInjectionHost.Shred>emptyList());
                }
                break block6;
            }
            List<Pair<PsiElement, TextRange>> injected = InjectedLanguageManager.getInstance(this.getProject()).getInjectedPsiFiles(hostContext);
            if (injected == null) break block6;
            for (Pair<PsiElement, TextRange> pair : injected) {
                PsiFile injectedFile = ((PsiElement)pair.first).getContainingFile();
                visitor.visit(injectedFile, ContainerUtil.<PsiLanguageInjectionHost.Shred>emptyList());
            }
        }
        return (PsiElement)result.get();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.pointsToTheSameElementAs(other)) {
            return false;
        }
        SmartPointerElementInfo myElementInfo = ((SmartPsiElementPointerImpl)((Object)this.myInjectedFileRangeInHostFile)).getElementInfo();
        SmartPointerElementInfo oElementInfo = ((SmartPsiElementPointerImpl)((Object)((InjectedSelfElementInfo)other).myInjectedFileRangeInHostFile)).getElementInfo();
        return myElementInfo.pointsToTheSameElementAs(oElementInfo);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        SmartPointerManager.getInstance(this.getProject()).removePointer(this.myInjectedFileRangeInHostFile);
    }
}

