/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionBase;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceExpressionImpl
extends PsiReferenceExpressionBase
implements PsiMethodReferenceExpression {
    private static Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl");

    public PsiMethodReferenceExpressionImpl() {
        super(JavaElementType.METHOD_REF_EXPRESSION);
    }

    @Override
    public PsiTypeElement getQualifierType() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiTypeElement ? (PsiTypeElement)qualifier : null;
    }

    @Override
    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return LambdaUtil.getFunctionalInterfaceType(this, true);
    }

    @Override
    public PsiExpression getQualifierExpression() {
        PsiElement qualifier = this.getQualifier();
        return qualifier instanceof PsiExpression ? (PsiExpression)qualifier : null;
    }

    @Override
    public PsiType getType() {
        return new PsiMethodReferenceType(this);
    }

    @Override
    public PsiElement getReferenceNameElement() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiIdentifier || PsiUtil.isJavaToken(element, JavaTokenType.NEW_KEYWORD) ? element : null;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "processVariants"));
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)ElementClassFilter.METHOD, processor);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        if (newQualifier == null) {
            super.setQualifierExpression(newQualifier);
            return;
        }
        PsiExpression expression = this.getQualifierExpression();
        if (expression != null) {
            expression.replace(newQualifier);
        } else {
            PsiElement qualifier = this.getQualifier();
            if (qualifier != null) {
                qualifier.replace(newQualifier);
            }
        }
    }

    @Override
    public int getChildRole(ASTNode child) {
        IElementType elType = child.getElementType();
        if (elType == JavaTokenType.DOUBLE_COLON) {
            return 253;
        }
        if (elType == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        if (elType == JavaElementType.REFERENCE_EXPRESSION) {
            return 119;
        }
        return 64;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        boolean valid;
        FileElement fileElement = SharedImplUtil.findFileElement(this);
        if (fileElement == null) {
            LOG.error("fileElement == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiManagerEx manager = fileElement.getManager();
        if (manager == null) {
            LOG.error("getManager() == null!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiFile file = SharedImplUtil.getContainingFile(fileElement);
        boolean bl = valid = file != null && file.isValid();
        if (!valid) {
            LOG.error("invalid!");
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        Project project = manager.getProject();
        MethodReferenceResolver resolver = new MethodReferenceResolver();
        Map<PsiMethodReferenceExpression, PsiType> map = PsiMethodReferenceUtil.ourRefs.get();
        if (map != null && map.containsKey(this)) {
            JavaResolveResult[] javaResolveResultArray = (JavaResolveResult[])resolver.resolve(this, incompleteCode);
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
            }
            return javaResolveResultArray;
        }
        ResolveResult[] results = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, resolver, true, incompleteCode, file);
        JavaResolveResult[] javaResolveResultArray = results.length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiElement getQualifier() {
        PsiElement element = this.getFirstChild();
        return element instanceof PsiExpression || element instanceof PsiTypeElement ? element : null;
    }

    @Override
    public TextRange getRangeInElement() {
        PsiElement element = this.getReferenceNameElement();
        if (element != null) {
            int offsetInParent = element.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + element.getTextLength());
        }
        PsiElement colons = this.findPsiChildByType(JavaTokenType.DOUBLE_COLON);
        if (colons != null) {
            int offsetInParent = colons.getStartOffsetInParent();
            return new TextRange(offsetInParent, offsetInParent + colons.getTextLength());
        }
        LOG.error(this.getText());
        return null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        PsiElement nameElement = this.getReferenceNameElement();
        if (nameElement instanceof PsiIdentifier ? !nameElement.getText().equals(method.getName()) : PsiUtil.isJavaToken(nameElement, JavaTokenType.NEW_KEYWORD) && !method.isConstructor()) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.resolve());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethodReferenceExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl", "bindToElement"));
        }
        return this;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            oldIdentifier = this.findChildByRoleAsPsiElement(119);
        }
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName) || "new".equals(oldRefName) || Comparing.strEqual(oldRefName, newElementName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public String toString() {
        return "PsiMethodReferenceExpression:" + this.getText();
    }

    private boolean isLocatedInStaticContext(PsiClass containingClass) {
        PsiClass gContainingClass = containingClass.getContainingClass();
        if (gContainingClass == null || !containingClass.hasModifierProperty("static")) {
            PsiClass aClass = null;
            if (PsiTreeUtil.isAncestor(gContainingClass != null ? gContainingClass : containingClass, this, false)) {
                PsiClass psiClass = aClass = gContainingClass != null ? gContainingClass : containingClass;
            }
            if (PsiUtil.getEnclosingStaticElement(this, aClass) != null) {
                return true;
            }
        }
        return false;
    }

    private class MethodReferenceResolver
    implements ResolveCache.PolyVariantResolver<PsiJavaReference> {
        private MethodReferenceResolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaReference reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
            }
            PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(PsiMethodReferenceExpressionImpl.this);
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            PsiSubstitutor substitutor = qualifierResolveResult.getSubstitutor();
            if (containingClass != null) {
                boolean isConstructor;
                PsiElement element = PsiMethodReferenceExpressionImpl.this.getReferenceNameElement();
                boolean bl = isConstructor = element instanceof PsiKeyword && "new".equals(element.getText());
                if (element instanceof PsiIdentifier || isConstructor) {
                    PsiConflictResolver[] resolvers;
                    PsiClassType.ClassResolveResult resolveResult;
                    PsiMethod interfaceMethod;
                    if (isConstructor && (containingClass.isEnum() || containingClass.hasModifierProperty("abstract"))) {
                        if (JavaResolveResult.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
                        }
                        return JavaResolveResult.EMPTY_ARRAY;
                    }
                    PsiType functionalInterfaceType = null;
                    Map<PsiMethodReferenceExpression, PsiType> map = PsiMethodReferenceUtil.ourRefs.get();
                    if (map != null) {
                        functionalInterfaceType = map.get(PsiMethodReferenceExpressionImpl.this);
                    }
                    if (functionalInterfaceType == null) {
                        functionalInterfaceType = PsiMethodReferenceExpressionImpl.this.getFunctionalInterfaceType();
                    }
                    final MethodSignature signature = (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType))) != null ? interfaceMethod.getSignature(LambdaUtil.getSubstitutor(interfaceMethod, resolveResult)) : null;
                    final PsiType interfaceMethodReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
                    final LanguageLevel languageLevel = PsiUtil.getLanguageLevel(PsiMethodReferenceExpressionImpl.this);
                    if (isConstructor && interfaceMethod != null) {
                        PsiTypeParameter[] typeParameters = containingClass.getTypeParameters();
                        boolean isRawSubst = PsiUtil.isRawSubstitutor(containingClass, substitutor);
                        PsiClassType returnType = JavaPsiFacade.getElementFactory(PsiMethodReferenceExpressionImpl.this.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : substitutor);
                        substitutor = LambdaUtil.inferFromReturnType(typeParameters, returnType, interfaceMethodReturnType, substitutor, languageLevel, PsiMethodReferenceExpressionImpl.this.getProject());
                        if (containingClass.getConstructors().length == 0) {
                            ResolveResult[] resolveResultArray;
                            ClassCandidateInfo candidateInfo = null;
                            if ((containingClass.getContainingClass() == null || !PsiMethodReferenceExpressionImpl.this.isLocatedInStaticContext(containingClass)) && signature.getParameterTypes().length == 0 || PsiMethodReferenceUtil.onArrayType(containingClass, signature)) {
                                candidateInfo = new ClassCandidateInfo(containingClass, substitutor);
                            }
                            if (candidateInfo == null) {
                                resolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                            } else {
                                JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[1];
                                resolveResultArray = javaResolveResultArray;
                                javaResolveResultArray[0] = candidateInfo;
                            }
                            if (resolveResultArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
                            }
                            return resolveResultArray;
                        }
                    }
                    MethodReferenceConflictResolver conflictResolver = new MethodReferenceConflictResolver(qualifierResolveResult, signature);
                    if (signature != null) {
                        PsiType[] parameterTypes = signature.getParameterTypes();
                        resolvers = new PsiConflictResolver[]{conflictResolver, new MethodRefsSpecificResolver(parameterTypes)};
                    } else {
                        resolvers = new PsiConflictResolver[]{conflictResolver};
                    }
                    MethodCandidatesProcessor processor = new MethodCandidatesProcessor(PsiMethodReferenceExpressionImpl.this, resolvers, new SmartList()){

                        @Override
                        protected MethodCandidateInfo createCandidateInfo(final PsiMethod method, final PsiSubstitutor substitutor, boolean staticProblem, boolean accessible) {
                            PsiExpressionList argumentList = this.getArgumentList();
                            return new MethodCandidateInfo(method, substitutor, !accessible, staticProblem, argumentList, this.myCurrentFileContext, argumentList != null ? argumentList.getExpressionTypes() : null, this.getTypeArguments(), this.getLanguageLevel()){

                                @Override
                                public PsiSubstitutor inferTypeArguments(ParameterTypeInferencePolicy policy) {
                                    return MethodReferenceResolver.this.inferTypeArgumentsFromInterfaceMethod(signature, interfaceMethodReturnType, method, substitutor, languageLevel);
                                }
                            };
                        }
                    };
                    processor.setIsConstructor(isConstructor);
                    processor.setName(isConstructor ? containingClass.getName() : element.getText());
                    PsiExpression expression = PsiMethodReferenceExpressionImpl.this.getQualifierExpression();
                    if (expression == null || !(expression.getType() instanceof PsiArrayType)) {
                        processor.setAccessClass(containingClass);
                    }
                    if (qualifierResolveResult.isReferenceTypeQualified() && PsiMethodReferenceExpressionImpl.this.isLocatedInStaticContext(containingClass)) {
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                    }
                    ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor);
                    containingClass.processDeclarations(processor, state, PsiMethodReferenceExpressionImpl.this, PsiMethodReferenceExpressionImpl.this);
                    ResolveResult[] resolveResultArray = processor.getResult();
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
                    }
                    return resolveResultArray;
                }
            }
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver", "resolve"));
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }

        private PsiSubstitutor inferTypeArgumentsFromInterfaceMethod(@Nullable MethodSignature signature, @Nullable PsiType interfaceMethodReturnType, PsiMethod method, PsiSubstitutor substitutor, LanguageLevel languageLevel) {
            if (signature == null) {
                return PsiSubstitutor.EMPTY;
            }
            PsiType[] types = method.getSignature(PsiUtil.isRawSubstitutor(method, substitutor) ? PsiSubstitutor.EMPTY : substitutor).getParameterTypes();
            PsiType[] rightTypes = signature.getParameterTypes();
            if (!method.isVarArgs() || types.length == 0) {
                if (types.length < rightTypes.length) {
                    return this.getSubstitutor(rightTypes[0]);
                }
                if (types.length > rightTypes.length) {
                    return this.getSubstitutor(types[0]);
                }
            } else if (rightTypes.length != types.length || rightTypes[rightTypes.length - 1].getArrayDimensions() != types[types.length - 1].getArrayDimensions()) {
                types[types.length - 1] = ((PsiArrayType)types[types.length - 1]).getComponentType();
                int min = Math.min(types.length, rightTypes.length);
                types = Arrays.copyOf(types, min);
                rightTypes = Arrays.copyOf(rightTypes, min);
            }
            for (int i = 0; i < rightTypes.length; ++i) {
                rightTypes[i] = GenericsUtil.eliminateWildcards(rightTypes[i]);
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(PsiMethodReferenceExpressionImpl.this.getProject()).getResolveHelper();
            PsiSubstitutor psiSubstitutor = resolveHelper.inferTypeArguments(method.getTypeParameters(), types, rightTypes, languageLevel);
            psiSubstitutor = psiSubstitutor.putAll(substitutor);
            if (method.isConstructor()) {
                psiSubstitutor = psiSubstitutor.putAll(resolveHelper.inferTypeArguments(method.getContainingClass().getTypeParameters(), types, rightTypes, languageLevel));
            }
            return LambdaUtil.inferFromReturnType(method.getTypeParameters(), psiSubstitutor.substitute(method.getReturnType()), interfaceMethodReturnType, psiSubstitutor, languageLevel, PsiMethodReferenceExpressionImpl.this.getProject());
        }

        private PsiSubstitutor getSubstitutor(PsiType type) {
            PsiClass psiClass;
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(type);
            PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
            if (type instanceof PsiClassType && (psiClass = resolveResult.getElement()) instanceof PsiTypeParameter) {
                for (PsiClass aClass : psiClass.getSupers()) {
                    psiSubstitutor = psiSubstitutor.putAll(TypeConversionUtil.getSuperClassSubstitutor(aClass, (PsiClassType)type));
                }
            }
            return psiSubstitutor;
        }

        private class MethodRefsSpecificResolver
        extends JavaMethodsConflictResolver {
            public MethodRefsSpecificResolver(PsiType[] parameterTypes) {
                super(PsiMethodReferenceExpressionImpl.this, parameterTypes);
            }

            @Override
            public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
                if (conflicts == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver$MethodRefsSpecificResolver", "resolveConflict"));
                }
                boolean varargs = false;
                for (CandidateInfo conflict : conflicts) {
                    PsiElement psiElement = conflict.getElement();
                    if (!(psiElement instanceof PsiMethod) || !((PsiMethod)psiElement).isVarArgs()) continue;
                    varargs = true;
                    break;
                }
                this.checkSpecifics(conflicts, varargs ? 2 : 3);
                return conflicts.size() == 1 ? conflicts.get(0) : null;
            }
        }

        private class MethodReferenceConflictResolver
        implements PsiConflictResolver {
            private final PsiClass myContainingClass;
            private final PsiSubstitutor mySubstitutor;
            private final MethodSignature mySignature;
            private final boolean myBeginsWithReferenceType;

            private MethodReferenceConflictResolver(PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable MethodSignature signature) {
                this.myContainingClass = qualifierResolveResult.getContainingClass();
                this.mySubstitutor = qualifierResolveResult.getSubstitutor();
                this.mySignature = signature;
                this.myBeginsWithReferenceType = qualifierResolveResult.isReferenceTypeQualified();
            }

            @Override
            @Nullable
            public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
                if (conflicts == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiMethodReferenceExpressionImpl$MethodReferenceResolver$MethodReferenceConflictResolver", "resolveConflict"));
                }
                if (this.mySignature == null) {
                    return null;
                }
                boolean hasReceiver = false;
                PsiType[] parameterTypes = this.mySignature.getParameterTypes();
                if (parameterTypes.length > 0 && PsiMethodReferenceUtil.isReceiverType(parameterTypes[0], this.myContainingClass, this.mySubstitutor)) {
                    hasReceiver = true;
                }
                ArrayList<CandidateInfo> firstCandidates = new ArrayList<CandidateInfo>();
                ArrayList<CandidateInfo> secondCandidates = new ArrayList<CandidateInfo>();
                for (CandidateInfo conflict : conflicts) {
                    PsiType type2;
                    PsiType type1;
                    int i;
                    boolean correct;
                    boolean staticOrValidConstructorRef;
                    PsiMethod psiMethod;
                    if (!(conflict instanceof MethodCandidateInfo) || (psiMethod = ((MethodCandidateInfo)conflict).getElement()) == null) continue;
                    PsiSubstitutor subst = PsiSubstitutor.EMPTY;
                    subst = subst.putAll(this.mySubstitutor);
                    subst = subst.putAll(conflict.getSubstitutor());
                    PsiType[] signatureParameterTypes2 = psiMethod.getSignature(subst).getParameterTypes();
                    boolean varArgs = psiMethod.isVarArgs();
                    boolean validConstructorRef = psiMethod.isConstructor() && (this.myContainingClass.getContainingClass() == null || this.myContainingClass.hasModifierProperty("static"));
                    boolean bl = staticOrValidConstructorRef = psiMethod.hasModifierProperty("static") || validConstructorRef;
                    if ((parameterTypes.length == signatureParameterTypes2.length || varArgs) && (!(this.myBeginsWithReferenceType ^ staticOrValidConstructorRef) || psiMethod.isConstructor() && conflict.isStaticsScopeCorrect())) {
                        correct = true;
                        for (i = 0; i < parameterTypes.length; ++i) {
                            type1 = subst.substitute(GenericsUtil.eliminateWildcards(parameterTypes[i]));
                            if (varArgs && i >= signatureParameterTypes2.length - 1) {
                                type2 = signatureParameterTypes2[signatureParameterTypes2.length - 1];
                                correct &= TypeConversionUtil.isAssignable(type2, type1) || TypeConversionUtil.isAssignable(((PsiArrayType)type2).getComponentType(), type1);
                                continue;
                            }
                            correct &= TypeConversionUtil.isAssignable(signatureParameterTypes2[i], type1);
                        }
                        if (correct) {
                            firstCandidates.add(conflict);
                        }
                    }
                    if (!hasReceiver || parameterTypes.length != signatureParameterTypes2.length + 1 || staticOrValidConstructorRef) continue;
                    correct = true;
                    for (i = 0; i < signatureParameterTypes2.length; ++i) {
                        type1 = subst.substitute(GenericsUtil.eliminateWildcards(parameterTypes[i + 1]));
                        type2 = signatureParameterTypes2[i];
                        boolean assignable = TypeConversionUtil.isAssignable(type2, type1);
                        if (varArgs && i == signatureParameterTypes2.length - 1) {
                            correct &= assignable || TypeConversionUtil.isAssignable(((PsiArrayType)type2).getComponentType(), type1);
                            continue;
                        }
                        correct &= assignable;
                    }
                    if (!correct) continue;
                    secondCandidates.add(conflict);
                }
                int acceptedCount = secondCandidates.size() + firstCandidates.size();
                if (acceptedCount != 1) {
                    if (acceptedCount == 0) {
                        conflicts.clear();
                    }
                    firstCandidates.addAll(secondCandidates);
                    conflicts.retainAll(firstCandidates);
                    return null;
                }
                return !firstCandidates.isEmpty() ? (CandidateInfo)firstCandidates.get(0) : (CandidateInfo)secondCandidates.get(0);
            }
        }
    }
}

