/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");

    private ReflectionUtil() {
    }

    public static ArrayList<Field> collectFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        ReflectionUtil.collectFields(clazz, result);
        return result;
    }

    public static Field findAssignableField(Class clazz, Class type, String name) throws NoSuchFieldException {
        ArrayList<Field> fields = ReflectionUtil.collectFields(clazz);
        for (Field each : fields) {
            if (!name.equals(each.getName()) || !type.isAssignableFrom(each.getType())) continue;
            return each;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    private static void collectFields(Class clazz, ArrayList<Field> result) {
        Class<?>[] interfaces;
        Field[] fields = clazz.getDeclaredFields();
        result.addAll(Arrays.asList(fields));
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtil.collectFields(superClass, result);
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            ReflectionUtil.collectFields(each, result);
        }
    }

    public static Object getField(Class objectClass, Object object, Class type, @NonNls String name) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, type, name);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(Class<T> aClass) {
        Constructor<T> constructor;
        try {
            Constructor<T> constructor2 = aClass.getConstructor(new Class[0]);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (NoSuchMethodException e) {
            LOG.error("No default constructor in " + aClass, e);
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
            }
            return null;
        }
        if (constructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        return constructor;
    }

    @NotNull
    public static <T> T createInstance(Constructor<T> constructor, Object ... args) {
        T t;
        try {
            t = constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            LOG.error(e);
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstance"));
            }
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstance"));
            }
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error(e);
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstance"));
            }
            return null;
        }
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        return t;
    }

    @Nullable
    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }
}

