/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import org.jetbrains.annotations.NotNull;

class OneElementFMap<V>
implements KeyFMap {
    private final int myKeyCode;
    private final V myValue;

    OneElementFMap(int keyCode, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/keyFMap/OneElementFMap", "<init>"));
        }
        this.myKeyCode = keyCode;
        this.myValue = value;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/keyFMap/OneElementFMap", "plus"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/keyFMap/OneElementFMap", "plus"));
        }
        int keyCode = key.hashCode();
        if (this.myKeyCode == keyCode) {
            OneElementFMap<V> oneElementFMap = new OneElementFMap<V>(keyCode, value);
            if (oneElementFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/OneElementFMap", "plus"));
            }
            return oneElementFMap;
        }
        PairElementsFMap pairElementsFMap = new PairElementsFMap(this.myKeyCode, this.myValue, keyCode, value);
        if (pairElementsFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/OneElementFMap", "plus"));
        }
        return pairElementsFMap;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/keyFMap/OneElementFMap", "minus"));
        }
        if (key.hashCode() == this.myKeyCode) {
            KeyFMap keyFMap = KeyFMap.EMPTY_MAP;
            if (keyFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/OneElementFMap", "minus"));
            }
            return keyFMap;
        }
        OneElementFMap oneElementFMap = this;
        if (oneElementFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/keyFMap/OneElementFMap", "minus"));
        }
        return oneElementFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/keyFMap/OneElementFMap", "get"));
        }
        return this.myKeyCode == key.hashCode() ? (V)this.myValue : null;
    }

    @Override
    public String toString() {
        return "<" + Key.getKeyByIndex(this.myKeyCode) + " -> " + this.myValue + ">";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

