/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

class MapBinding
implements Binding {
    private final Binding myKeyBinding;
    private final Binding myValueBinding;
    private final MapAnnotation myMapAnnotation;
    private static final Comparator<Object> KEY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            return 0;
        }
    };

    public MapBinding(ParameterizedType type, Accessor accessor) {
        Type[] arguments = type.getActualTypeArguments();
        Type keyType = arguments[0];
        Type valueType = arguments[1];
        this.myKeyBinding = XmlSerializerImpl.getBinding(keyType);
        this.myValueBinding = XmlSerializerImpl.getBinding(valueType);
        this.myMapAnnotation = XmlSerializerImpl.findAnnotation(accessor.getAnnotations(), MapAnnotation.class);
    }

    private String getEntryAttributeName() {
        return this.myMapAnnotation == null ? "entry" : this.myMapAnnotation.entryTagName();
    }

    private String getValueAttributeName() {
        return this.myMapAnnotation == null ? "value" : this.myMapAnnotation.valueAttributeName();
    }

    private String getKeyAttributeValue() {
        return this.myMapAnnotation == null ? "key" : this.myMapAnnotation.keyAttributeName();
    }

    @Override
    public Object deserialize(Object o, Object ... nodes) {
        Object[] childNodes;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xmlb/MapBinding", "deserialize"));
        }
        Map map = (Map)o;
        map.clear();
        if (this.myMapAnnotation == null || this.myMapAnnotation.surroundWithTag()) {
            assert (nodes.length == 1);
            Element m = (Element)nodes[0];
            childNodes = JDOMUtil.getContent(m);
        } else {
            childNodes = nodes;
        }
        for (Object childNode : childNodes) {
            if (XmlSerializerImpl.isIgnoredNode(childNode)) continue;
            Element entry = (Element)childNode;
            Object k = null;
            Object v = null;
            assert (entry.getName().equals(this.getEntryAttributeName()));
            Attribute keyAttr = entry.getAttribute(this.getKeyAttributeValue());
            if (keyAttr != null) {
                k = this.myKeyBinding.deserialize(o, keyAttr);
            } else if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundKeyWithTag()) {
                Content[] children;
                for (Content child : children = JDOMUtil.getContent(entry)) {
                    if (!this.myKeyBinding.isBoundTo(child)) continue;
                    k = this.myKeyBinding.deserialize(o, child);
                    break;
                }
                assert (k != null) : "no key found";
            } else {
                Element keyNode = entry.getChildren(this.getKeyAttributeValue()).get(0);
                k = this.myKeyBinding.deserialize(o, JDOMUtil.getContent(keyNode));
            }
            Attribute valueAttr = entry.getAttribute(this.getValueAttributeName());
            if (valueAttr != null) {
                v = this.myValueBinding.deserialize(o, valueAttr);
            } else if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundValueWithTag()) {
                Content[] children;
                for (Content child : children = JDOMUtil.getContent(entry)) {
                    if (!this.myValueBinding.isBoundTo(child)) continue;
                    v = this.myValueBinding.deserialize(o, child);
                    break;
                }
                assert (v != null) : "no value found";
            } else {
                Element valueNode = entry.getChildren(this.getValueAttributeName()).get(0);
                v = this.myValueBinding.deserialize(o, XmlSerializerImpl.getNotIgnoredContent(valueNode));
            }
            map.put(k, v);
        }
        return map;
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        if (this.myMapAnnotation != null && !this.myMapAnnotation.surroundWithTag()) {
            return this.myMapAnnotation.entryTagName().equals(((Element)node).getName());
        }
        return ((Element)node).getName().equals("map");
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    @Override
    public void init() {
    }
}

