/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.IntIterator;
import jet.IntProgressionIterator;
import jet.Progression;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class IntRange
implements Progression<Integer>,
Range<Integer> {
    public static final IntRange EMPTY = new IntRange(1, 0);
    private final int start;
    private final int end;

    public IntRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean contains(Integer item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public boolean contains(int item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public Integer getStart() {
        return this.start;
    }

    @Override
    public Integer getEnd() {
        return this.end;
    }

    @Override
    public Integer getIncrement() {
        return 1;
    }

    public IntIterator iterator() {
        return new IntProgressionIterator(this.start, this.end, 1);
    }

    public String toString() {
        return this.start + ".." + this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntRange range = (IntRange)o;
        return this.end == range.end && this.start == range.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        return result;
    }
}

