/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.analyzer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.types.ErrorUtils;

public class AnalyzeExhaust {
    private final BindingContext bindingContext;
    private final Throwable error;
    private final BodiesResolveContext bodiesResolveContext;
    private final ModuleDescriptor moduleDescriptor;

    public static AnalyzeExhaust success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module) {
        return new AnalyzeExhaust(bindingContext, module, null, null);
    }

    public static AnalyzeExhaust success(@NotNull BindingContext bindingContext, @Nullable BodiesResolveContext bodiesResolveContext, @NotNull ModuleDescriptor module) {
        return new AnalyzeExhaust(bindingContext, module, bodiesResolveContext, null);
    }

    public static AnalyzeExhaust error(@NotNull BindingContext bindingContext, @NotNull Throwable error) {
        return new AnalyzeExhaust(bindingContext, ErrorUtils.getErrorModule(), null, error);
    }

    private AnalyzeExhaust(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, @Nullable BodiesResolveContext bodiesResolveContext, @Nullable Throwable error) {
        this.bindingContext = bindingContext;
        this.error = error;
        this.bodiesResolveContext = bodiesResolveContext;
        this.moduleDescriptor = moduleDescriptor;
    }

    @Nullable
    public BodiesResolveContext getBodiesResolveContext() {
        return this.bodiesResolveContext;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public Throwable getError() {
        return this.error;
    }

    public boolean isError() {
        return this.error != null;
    }

    public void throwIfError() {
        if (this.isError()) {
            throw new IllegalStateException("failed to analyze: " + this.error, this.error);
        }
    }

    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }
}

