/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.Label;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.signature.JvmPropertyAccessorSignature;
import org.jetbrains.jet.codegen.signature.kotlin.JetMethodAnnotationWriter;
import org.jetbrains.jet.codegen.signature.kotlin.JetValueParameterAnnotationWriter;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.GenerationStateAware;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.codegen.state.JetTypeMapperMode;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.DescriptorKindUtils;
import org.jetbrains.jet.lang.resolve.name.Name;

public class FunctionCodegen
extends GenerationStateAware {
    private final CodegenContext owner;
    private final ClassBuilder v;

    public FunctionCodegen(CodegenContext owner, ClassBuilder v, GenerationState state) {
        super(state);
        this.owner = owner;
        this.v = v;
    }

    public void gen(@NotNull JetNamedFunction function) {
        SimpleFunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, function);
        assert (functionDescriptor != null);
        OwnerKind kind = this.owner.getContextKind();
        JvmMethodSignature method = this.typeMapper.mapSignature(functionDescriptor, true, kind);
        if (kind != OwnerKind.TRAIT_IMPL || function.getBodyExpression() != null) {
            boolean needJetAnnotations = kind != OwnerKind.TRAIT_IMPL;
            this.generateMethod(function, method, needJetAnnotations, functionDescriptor, new FunctionGenerationStrategy.FunctionDefault(this.state, functionDescriptor, function));
        }
        FunctionCodegen.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor), this.state, this.v, method, functionDescriptor, kind, DefaultParameterValueLoader.DEFAULT);
    }

    public void generateMethod(@Nullable PsiElement origin, @NotNull JvmMethodSignature jvmSignature, boolean needJetAnnotations, @NotNull FunctionDescriptor functionDescriptor, @NotNull FunctionGenerationStrategy strategy) {
        this.generateMethod(origin, jvmSignature, needJetAnnotations, functionDescriptor, this.owner.intoFunction(functionDescriptor), strategy);
    }

    public void generateMethod(@Nullable PsiElement origin, @NotNull JvmMethodSignature jvmSignature, boolean needJetAnnotations, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy) {
        Method asmMethod = jvmSignature.getAsmMethod();
        MethodVisitor mv = this.v.newMethod(origin, AsmUtil.getMethodAsmFlags(functionDescriptor, methodContext.getContextKind()), asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), null);
        AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(functionDescriptor);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.SIGNATURES) {
            return;
        }
        if (needJetAnnotations) {
            this.genJetAnnotations(mv, functionDescriptor, jvmSignature);
        }
        if (AsmUtil.isAbstractMethod(functionDescriptor, methodContext.getContextKind())) {
            return;
        }
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            AsmUtil.genStubCode(mv);
            return;
        }
        this.generateMethodBody(mv, functionDescriptor, methodContext, jvmSignature, strategy);
        FunctionCodegen.endVisit(mv, null, origin);
        FunctionCodegen.generateBridgeIfNeeded(this.owner, this.state, this.v, jvmSignature.getAsmMethod(), functionDescriptor);
        methodContext.recordSyntheticAccessorIfNeeded(functionDescriptor, this.typeMapper);
    }

    @Nullable
    private Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context) {
        ReceiverParameterDescriptor expectedThisObject = functionDescriptor.getExpectedThisObject();
        if (functionDescriptor instanceof ConstructorDescriptor) {
            return this.typeMapper.mapType(functionDescriptor.getReturnType());
        }
        if (expectedThisObject != null) {
            return this.typeMapper.mapType(expectedThisObject.getType());
        }
        if (DescriptorUtils.isFunctionLiteral(functionDescriptor) || CodegenBinding.isLocalNamedFun(functionDescriptor)) {
            return this.typeMapper.mapType(context.getThisDescriptor());
        }
        return null;
    }

    private void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JvmMethodSignature signature, @NotNull FunctionGenerationStrategy strategy) {
        HashSet<String> localVariableNames = new HashSet<String>(FunctionCodegen.getParameterNamesAsStrings(functionDescriptor));
        HashMap<Name, Label> labelsForSharedVars = new HashMap<Name, Label>();
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        OwnerKind kind = context.getContextKind();
        if (kind instanceof OwnerKind.StaticDelegateKind) {
            FunctionCodegen.generateStaticDelegateMethodBody(mv, signature.getAsmMethod(), (OwnerKind.StaticDelegateKind)kind);
        } else {
            FrameMap frameMap = strategy.getFrameMap(this.typeMapper, context);
            for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
                frameMap.enter(parameter, this.typeMapper.mapType(parameter));
            }
            labelsForSharedVars.putAll(this.createSharedVarsForParameters(mv, functionDescriptor, frameMap));
            if (!JetTypeMapper.isAccessor(functionDescriptor)) {
                AsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), this.state, functionDescriptor, frameMap);
            }
            strategy.generateBody(mv, signature, context);
            localVariableNames.addAll(strategy.getLocalVariableNames());
        }
        Label methodEnd = new Label();
        mv.visitLabel(methodEnd);
        Type thisType = this.getThisTypeForFunction(functionDescriptor, context);
        this.generateLocalVariableTable(mv, signature, functionDescriptor, thisType, methodBegin, methodEnd, localVariableNames, labelsForSharedVars, kind);
    }

    @NotNull
    private static List<String> getParameterNamesAsStrings(@NotNull FunctionDescriptor functionDescriptor) {
        List<ValueParameterDescriptor> parameters = functionDescriptor.getValueParameters();
        ArrayList<String> result = new ArrayList<String>(parameters.size());
        for (ValueParameterDescriptor parameter : parameters) {
            result.add(parameter.getName().asString());
        }
        return result;
    }

    private void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull Collection<String> localVariableNames, @NotNull Map<Name, Label> labelsForSharedVars, @NotNull OwnerKind ownerKind) {
        Iterator<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> params = jvmMethodSignature.getKotlinParameterTypes();
        int shift = 0;
        boolean isStatic = AsmUtil.isStaticMethod(ownerKind, functionDescriptor);
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        for (int i = 0; i < params.size(); ++i) {
            JvmMethodParameterSignature param = params.get(i);
            JvmMethodParameterKind kind = param.getKind();
            String parameterName = "$" + param.getKind().name().toLowerCase();
            if (this.needIndexForVar(kind)) {
                parameterName = parameterName + "$" + i;
            }
            Type type = param.getAsmType();
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = valueParameters.next();
                Label divideLabel = labelsForSharedVars.get(parameter.getName());
                parameterName = parameter.getName().asString();
                if (divideLabel != null) {
                    mv.visitLocalVariable(parameterName, type.getDescriptor(), null, methodBegin, divideLabel, shift);
                    String nameForSharedVar = CodegenUtil.createTmpVariableName(localVariableNames);
                    localVariableNames.add(nameForSharedVar);
                    Type sharedVarType = this.typeMapper.getSharedVarType(parameter);
                    mv.visitLocalVariable(nameForSharedVar, sharedVarType.getDescriptor(), null, divideLabel, methodEnd, shift);
                    shift += Math.max(type.getSize(), sharedVarType.getSize());
                    continue;
                }
            }
            mv.visitLocalVariable(parameterName, type.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type.getSize();
        }
    }

    @NotNull
    private Map<Name, Label> createSharedVarsForParameters(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull FrameMap frameMap) {
        HashMap<Name, Label> labelsForSharedVars = new HashMap<Name, Label>();
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            Type sharedVarType = this.typeMapper.getSharedVarType(parameter);
            if (sharedVarType == null) continue;
            Type localVarType = this.typeMapper.mapType(parameter);
            int index = frameMap.getIndex(parameter);
            mv.visitTypeInsn(187, sharedVarType.getInternalName());
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitMethodInsn(183, sharedVarType.getInternalName(), "<init>", "()V");
            mv.visitVarInsn(localVarType.getOpcode(21), index);
            mv.visitFieldInsn(181, sharedVarType.getInternalName(), "ref", StackValue.refType(localVarType).getDescriptor());
            Label labelForSharedVar = new Label();
            mv.visitLabel(labelForSharedVar);
            labelsForSharedVars.put(parameter.getName(), labelForSharedVar);
            mv.visitVarInsn(sharedVarType.getOpcode(54), index);
        }
        return labelsForSharedVars;
    }

    private static void generateStaticDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull OwnerKind.StaticDelegateKind dk) {
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        int k = 0;
        for (Type argType : argTypes) {
            iv.load(k, argType);
            k += argType.getSize();
        }
        iv.invokestatic(dk.getOwnerClass(), asmMethod.getName(), asmMethod.getDescriptor());
        iv.areturn(asmMethod.getReturnType());
    }

    private void genJetAnnotations(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull JvmMethodSignature jvmSignature) {
        if (functionDescriptor instanceof PropertyAccessorDescriptor) {
            assert (jvmSignature instanceof JvmPropertyAccessorSignature) : "jvmSignature for property should have JvmPropertyAccessorSignature type";
            PropertyCodegen.generateJetPropertyAnnotation(mv, (JvmPropertyAccessorSignature)jvmSignature, ((PropertyAccessorDescriptor)functionDescriptor).getCorrespondingProperty(), functionDescriptor.getVisibility());
        } else if (functionDescriptor instanceof SimpleFunctionDescriptor) {
            assert (!(jvmSignature instanceof JvmPropertyAccessorSignature)) : "jvmSignature for function shouldn't have JvmPropertyAccessorSignature type";
            Modality modality = functionDescriptor.getModality();
            JetMethodAnnotationWriter aw = JetMethodAnnotationWriter.visitAnnotation(mv);
            int kotlinFlags = CodegenUtil.getFlagsForVisibility(functionDescriptor.getVisibility());
            if (CodegenUtil.isInterface(functionDescriptor.getContainingDeclaration()) && modality != Modality.ABSTRACT) {
                kotlinFlags |= modality == Modality.FINAL ? 4 : 2;
            }
            aw.writeFlags(kotlinFlags |= DescriptorKindUtils.kindToFlags(functionDescriptor.getKind()));
            if (jvmSignature.getKotlinTypeParameter() != null) {
                aw.writeTypeParameters(jvmSignature.getKotlinTypeParameter());
            }
            aw.writeReturnType(jvmSignature.getKotlinReturnType());
            aw.visitEnd();
        } else if (functionDescriptor instanceof ConstructorDescriptor) {
            AnnotationVisitor jetConstructorVisitor = mv.visitAnnotation(JvmStdlibNames.JET_CONSTRUCTOR.getDescriptor(), true);
            int flagsValue = CodegenUtil.getFlagsForVisibility(functionDescriptor.getVisibility());
            if (0 != flagsValue) {
                jetConstructorVisitor.visit("flags", flagsValue);
            }
            jetConstructorVisitor.visitEnd();
        } else {
            throw new IllegalStateException();
        }
        this.generateMethodParametersAnnotations(mv, functionDescriptor, jvmSignature);
    }

    void generateMethodParametersAnnotations(MethodVisitor mv, FunctionDescriptor functionDescriptor, JvmMethodSignature jvmSignature) {
        Iterator<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getKotlinParameterTypes();
        assert (kotlinParameterTypes != null);
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            JvmMethodParameterSignature param = kotlinParameterTypes.get(i);
            JvmMethodParameterKind kind = param.getKind();
            String parameterName = "$" + param.getKind().name().toLowerCase();
            ValueParameterDescriptor parameterDescriptor = null;
            if (kind == JvmMethodParameterKind.VALUE) {
                parameterDescriptor = valueParameters.next();
                parameterName = parameterDescriptor.getName().asString();
            } else {
                if (kind == JvmMethodParameterKind.ENUM_NAME || kind == JvmMethodParameterKind.ENUM_ORDINAL) continue;
                if (this.needIndexForVar(kind)) {
                    parameterName = parameterName + "$" + i;
                }
            }
            AnnotationCodegen.forParameter(i, mv, this.typeMapper).genAnnotations(parameterDescriptor);
            JetValueParameterAnnotationWriter av = JetValueParameterAnnotationWriter.visitParameterAnnotation(mv, i);
            av.writeName(parameterName);
            if (kind == JvmMethodParameterKind.RECEIVER) {
                av.writeReceiver();
            }
            if (parameterDescriptor != null) {
                av.writeHasDefaultValue(parameterDescriptor.declaresDefaultValue());
                av.writeVararg(parameterDescriptor.getVarargElementType() != null);
            }
            av.writeType(param.getKotlinSignature());
            av.visitEnd();
        }
    }

    private boolean needIndexForVar(JvmMethodParameterKind kind) {
        return kind == JvmMethodParameterKind.SHARED_VAR || kind == JvmMethodParameterKind.SUPER_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CompilationException("wrong code generated" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage(), t, method);
        }
        mv.visitEnd();
    }

    static void generateBridgeIfNeeded(CodegenContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, FunctionDescriptor functionDescriptor) {
        if (owner.getContextKind() == OwnerKind.TRAIT_IMPL) {
            return;
        }
        Method method = state.getTypeMapper().mapSignature(functionDescriptor).getAsmMethod();
        LinkedList<FunctionDescriptor> bfsQueue = new LinkedList<FunctionDescriptor>();
        HashSet<FunctionDescriptor> visited = new HashSet<FunctionDescriptor>();
        bfsQueue.offer(functionDescriptor.getOriginal());
        visited.add(functionDescriptor.getOriginal());
        for (FunctionDescriptor functionDescriptor2 : functionDescriptor.getOverriddenDescriptors()) {
            FunctionDescriptor orig = functionDescriptor2.getOriginal();
            if (visited.contains(orig)) continue;
            bfsQueue.offer(functionDescriptor2);
            visited.add(functionDescriptor2);
        }
        HashSet<Method> bridgesToGenerate = new HashSet<Method>();
        while (!bfsQueue.isEmpty()) {
            FunctionDescriptor functionDescriptor3 = (FunctionDescriptor)bfsQueue.poll();
            if (functionDescriptor3.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
                Method overridden = state.getTypeMapper().mapSignature(functionDescriptor3.getOriginal()).getAsmMethod();
                if (!FunctionCodegen.differentMethods(method, overridden)) continue;
                bridgesToGenerate.add(overridden);
                continue;
            }
            for (FunctionDescriptor functionDescriptor4 : functionDescriptor3.getOverriddenDescriptors()) {
                FunctionDescriptor orig = functionDescriptor4.getOriginal();
                if (visited.contains(orig)) continue;
                bfsQueue.offer(orig);
                visited.add(orig);
            }
        }
        for (Method overridden : bridgesToGenerate) {
            FunctionCodegen.generateBridge(owner, state, v, jvmSignature, functionDescriptor, overridden);
        }
    }

    static void generateConstructorWithoutParametersIfNeeded(@NotNull GenerationState state, @NotNull CallableMethod method, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull ClassBuilder classBuilder) {
        if (!FunctionCodegen.isDefaultConstructorNeeded(state.getBindingContext(), constructorDescriptor)) {
            return;
        }
        int flags = AsmUtil.getVisibilityAccessFlag(constructorDescriptor);
        MethodVisitor mv = classBuilder.newMethod(null, flags, "<init>", "()V", null, null);
        if (state.getClassBuilderMode() == ClassBuilderMode.SIGNATURES) {
            return;
        }
        if (state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            AsmUtil.genStubCode(mv);
        } else if (state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            InstructionAdapter v = new InstructionAdapter(mv);
            mv.visitCode();
            JvmClassName ownerInternalName = method.getOwner();
            Method jvmSignature = method.getSignature().getAsmMethod();
            v.load(0, ownerInternalName.getAsmType());
            int mask = 0;
            for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
                Type paramType = state.getTypeMapper().mapType(parameterDescriptor.getType());
                AsmUtil.pushDefaultValueOnStack(paramType, v);
                mask |= 1 << parameterDescriptor.getIndex();
            }
            v.iconst(mask);
            String desc = jvmSignature.getDescriptor().replace(")", "I)");
            v.invokespecial(ownerInternalName.getInternalName(), "<init>", desc);
            v.areturn(Type.VOID_TYPE);
            FunctionCodegen.endVisit(mv, "default constructor for " + ownerInternalName.getInternalName(), null);
        }
    }

    static void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull GenerationState state, @NotNull ClassBuilder v, @NotNull JvmMethodSignature signature, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, @NotNull DefaultParameterValueLoader loadStrategy) {
        DeclarationDescriptor contextClass = owner.getContextDescriptor().getContainingDeclaration();
        if (kind != OwnerKind.TRAIT_IMPL && contextClass instanceof ClassDescriptor && ((ClassDescriptor)contextClass).getKind() == ClassKind.TRAIT) {
            return;
        }
        if (!FunctionCodegen.isDefaultNeeded(functionDescriptor)) {
            return;
        }
        boolean isStatic = AsmUtil.isStatic(kind);
        Method jvmSignature = signature.getAsmMethod();
        int flags = 4097;
        JvmClassName ownerInternalName = contextClass instanceof NamespaceDescriptor ? state.getTypeMapper().getOwner(functionDescriptor, kind, true) : JvmClassName.byType(state.getTypeMapper().mapType(((ClassDescriptor)contextClass).getDefaultType(), JetTypeMapperMode.IMPL));
        String descriptor = jvmSignature.getDescriptor().replace(")", "I)");
        boolean isConstructor = "<init>".equals(jvmSignature.getName());
        if (!isStatic && !isConstructor) {
            descriptor = descriptor.replace("(", "(" + ownerInternalName.getDescriptor());
        }
        MethodVisitor mv = v.newMethod(null, flags | (isConstructor ? 0 : 8), isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor, null, null);
        if (state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            AsmUtil.genStubCode(mv);
        } else if (state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            FunctionCodegen.generateDefaultImpl(owner, state, signature, functionDescriptor, kind, isStatic, mv, loadStrategy);
        }
    }

    private static void generateDefaultImpl(@NotNull MethodContext methodContext, @NotNull GenerationState state, @NotNull JvmMethodSignature signature, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, boolean aStatic, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy) {
        mv.visitCode();
        FrameMap frameMap = new FrameMap();
        if (!aStatic) {
            frameMap.enterTemp(AsmTypeConstants.OBJECT_TYPE);
        }
        Method jvmSignature = signature.getAsmMethod();
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, jvmSignature.getReturnType(), methodContext, state);
        Type[] argTypes = jvmSignature.getArgumentTypes();
        List<ValueParameterDescriptor> paramDescrs = functionDescriptor.getValueParameters();
        Iterator<ValueParameterDescriptor> iterator = paramDescrs.iterator();
        int countOfExtraVarsInMethodArgs = 0;
        List<JvmMethodParameterSignature> params = signature.getKotlinParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            JvmMethodParameterSignature parameterSignature = params.get(i);
            if (parameterSignature.getKind() != JvmMethodParameterKind.VALUE) {
                ++countOfExtraVarsInMethodArgs;
                frameMap.enterTemp(parameterSignature.getAsmType());
                continue;
            }
            frameMap.enter(iterator.next(), parameterSignature.getAsmType());
        }
        int maskIndex = frameMap.enterTemp(Type.INT_TYPE);
        InstructionAdapter iv = new InstructionAdapter(mv);
        FunctionCodegen.loadExplicitArgumentsOnStack(iv, AsmTypeConstants.OBJECT_TYPE, aStatic, signature);
        for (int index = 0; index < paramDescrs.size(); ++index) {
            ValueParameterDescriptor parameterDescriptor = paramDescrs.get(index);
            Type t = argTypes[countOfExtraVarsInMethodArgs + index];
            if (parameterDescriptor.declaresDefaultValue()) {
                iv.load(maskIndex, Type.INT_TYPE);
                iv.iconst(1 << index);
                iv.and(Type.INT_TYPE);
                Label loadArg = new Label();
                iv.ifeq(loadArg);
                loadStrategy.putValueOnStack(parameterDescriptor, codegen);
                int ind = frameMap.getIndex(parameterDescriptor);
                iv.store(ind, t);
                iv.mark(loadArg);
            }
            iv.load(frameMap.getIndex(parameterDescriptor), t);
        }
        CallableMethod method = null;
        method = functionDescriptor instanceof ConstructorDescriptor ? state.getTypeMapper().mapToCallableMethod((ConstructorDescriptor)functionDescriptor) : state.getTypeMapper().mapToCallableMethod(functionDescriptor, false, CodegenUtil.isCallInsideSameClassAsDeclared(functionDescriptor, methodContext), CodegenUtil.isCallInsideSameModuleAsDeclared(functionDescriptor, methodContext), OwnerKind.IMPLEMENTATION);
        iv.visitMethodInsn(method.getInvokeOpcode(), method.getOwner().getInternalName(), method.getSignature().getAsmMethod().getName(), method.getSignature().getAsmMethod().getDescriptor());
        iv.areturn(jvmSignature.getReturnType());
        FunctionCodegen.endVisit(mv, "default method", BindingContextUtils.callableDescriptorToDeclaration(state.getBindingContext(), functionDescriptor));
        mv.visitEnd();
    }

    private static void loadExplicitArgumentsOnStack(@NotNull InstructionAdapter iv, @NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature) {
        int var = 0;
        if (!isStatic) {
            iv.load(var, ownerType);
            var += ownerType.getSize();
        }
        List<JvmMethodParameterSignature> params = signature.getKotlinParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            JvmMethodParameterSignature parameterSignature = params.get(i);
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type = parameterSignature.getAsmType();
            iv.load(var, type);
            var += type.getSize();
        }
    }

    private static boolean isDefaultNeeded(FunctionDescriptor functionDescriptor) {
        boolean needed = false;
        if (functionDescriptor != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
                if (!parameterDescriptor.declaresDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    private static boolean isDefaultConstructorNeeded(@NotNull BindingContext context, @NotNull ConstructorDescriptor constructorDescriptor) {
        ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
        if (CodegenBinding.canHaveOuter(context, classDescriptor)) {
            return false;
        }
        if (classDescriptor.getVisibility() == Visibilities.PRIVATE || constructorDescriptor.getVisibility() == Visibilities.PRIVATE) {
            return false;
        }
        if (constructorDescriptor.getValueParameters().isEmpty()) {
            return false;
        }
        for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
            if (parameterDescriptor.declaresDefaultValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean differentMethods(Method method, Method overridden) {
        Type[] overriddenArgumentTypes;
        if (!method.getReturnType().equals(overridden.getReturnType())) {
            return true;
        }
        Type[] methodArgumentTypes = method.getArgumentTypes();
        if (methodArgumentTypes.length != (overriddenArgumentTypes = overridden.getArgumentTypes()).length) {
            return true;
        }
        for (int i = 0; i != methodArgumentTypes.length; ++i) {
            if (methodArgumentTypes[i].equals(overriddenArgumentTypes[i])) continue;
            return true;
        }
        return false;
    }

    private static void generateBridge(CodegenContext owner, GenerationState state, ClassBuilder v, Method jvmSignature, FunctionDescriptor functionDescriptor, Method overridden) {
        int flags = 4161;
        MethodVisitor mv = v.newMethod(null, flags, jvmSignature.getName(), overridden.getDescriptor(), null, null);
        if (state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            AsmUtil.genStubCode(mv);
        } else if (state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            Type[] argTypes = overridden.getArgumentTypes();
            Type[] originalArgTypes = jvmSignature.getArgumentTypes();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            int reg = 1;
            for (int i = 0; i < argTypes.length; ++i) {
                StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                reg += argTypes[i].getSize();
            }
            iv.invokevirtual(v.getThisName(), jvmSignature.getName(), jvmSignature.getDescriptor());
            StackValue.onStack(jvmSignature.getReturnType()).put(overridden.getReturnType(), iv);
            iv.areturn(overridden.getReturnType());
            FunctionCodegen.endVisit(mv, "bridge method", BindingContextUtils.callableDescriptorToDeclaration(state.getBindingContext(), functionDescriptor));
        }
    }

    public void genDelegate(FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor, StackValue field) {
        this.genDelegate(functionDescriptor, (ClassDescriptor)overriddenDescriptor.getContainingDeclaration(), field, this.typeMapper.mapSignature(functionDescriptor), this.typeMapper.mapSignature(overriddenDescriptor.getOriginal()));
    }

    public void genDelegate(FunctionDescriptor functionDescriptor, ClassDescriptor toClass, StackValue field, JvmMethodSignature jvmDelegateMethodSignature, JvmMethodSignature jvmOverriddenMethodSignature) {
        Method overriddenMethod = jvmOverriddenMethodSignature.getAsmMethod();
        Method delegateMethod = jvmDelegateMethodSignature.getAsmMethod();
        int flags = 4097;
        MethodVisitor mv = this.v.newMethod(null, flags, delegateMethod.getName(), delegateMethod.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.STUBS) {
            AsmUtil.genStubCode(mv);
        } else if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            Type[] argTypes = delegateMethod.getArgumentTypes();
            Type[] originalArgTypes = overriddenMethod.getArgumentTypes();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            field.put(field.type, iv);
            int reg = 1;
            for (int i = 0; i < argTypes.length; ++i) {
                StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
                reg += argTypes[i].getSize();
            }
            String internalName = this.typeMapper.mapType(toClass).getInternalName();
            if (toClass.getKind() == ClassKind.TRAIT) {
                iv.invokeinterface(internalName, overriddenMethod.getName(), overriddenMethod.getDescriptor());
            } else {
                iv.invokevirtual(internalName, overriddenMethod.getName(), overriddenMethod.getDescriptor());
            }
            StackValue.onStack(overriddenMethod.getReturnType()).put(delegateMethod.getReturnType(), iv);
            iv.areturn(delegateMethod.getReturnType());
            FunctionCodegen.endVisit(mv, "Delegate method " + functionDescriptor + " to " + jvmOverriddenMethodSignature, BindingContextUtils.descriptorToDeclaration(this.bindingContext, functionDescriptor.getContainingDeclaration()));
            FunctionCodegen.generateBridgeIfNeeded(this.owner, this.state, this.v, jvmDelegateMethodSignature.getAsmMethod(), functionDescriptor);
        }
    }
}

