/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public abstract class JetQualifiedExpression
extends JetExpressionImpl {
    public JetQualifiedExpression(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public JetExpression getReceiverExpression() {
        JetExpression left = this.findChildByClass(JetExpression.class);
        assert (left != null);
        return left;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getSelectorExpression() {
        for (ASTNode node = this.getOperationTokenNode(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetExpression)) continue;
            return (JetExpression)psi;
        }
        return null;
    }

    @NotNull
    public ASTNode getOperationTokenNode() {
        ASTNode operationNode = this.getNode().findChildByType(JetTokens.OPERATIONS);
        assert (operationNode != null);
        return operationNode;
    }

    @NotNull
    public JetToken getOperationSign() {
        return (JetToken)this.getOperationTokenNode().getElementType();
    }
}

