/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationStub;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.stubs.PsiJetTypeParameterStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lexer.JetTokens;

public class JetTypeParameter
extends JetNamedDeclarationStub<PsiJetTypeParameterStub> {
    public static final JetTypeParameter[] EMPTY_ARRAY = new JetTypeParameter[0];
    public static final ArrayFactory<JetTypeParameter> ARRAY_FACTORY = new ArrayFactory<JetTypeParameter>(){

        public JetTypeParameter[] create(int count) {
            return count == 0 ? EMPTY_ARRAY : new JetTypeParameter[count];
        }
    };

    public JetTypeParameter(@NotNull ASTNode node) {
        super(node);
    }

    public JetTypeParameter(@NotNull PsiJetTypeParameterStub stub, @NotNull IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitTypeParameter(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitTypeParameter(this, data);
    }

    @NotNull
    public Variance getVariance() {
        PsiJetTypeParameterStub stub = (PsiJetTypeParameterStub)this.getStub();
        if (stub != null) {
            if (stub.isOutVariance()) {
                return Variance.OUT_VARIANCE;
            }
            if (stub.isInVariance()) {
                return Variance.IN_VARIANCE;
            }
            return Variance.INVARIANT;
        }
        JetModifierList modifierList = this.getModifierList();
        if (modifierList == null) {
            return Variance.INVARIANT;
        }
        if (modifierList.hasModifier(JetTokens.OUT_KEYWORD)) {
            return Variance.OUT_VARIANCE;
        }
        if (modifierList.hasModifier(JetTokens.IN_KEYWORD)) {
            return Variance.IN_VARIANCE;
        }
        return Variance.INVARIANT;
    }

    @Nullable
    public JetTypeReference getExtendsBound() {
        return (JetTypeReference)this.findChildByType(JetNodeTypes.TYPE_REFERENCE);
    }

    @Override
    @NotNull
    public IStubElementType getElementType() {
        return JetStubElementTypes.TYPE_PARAMETER;
    }
}

