/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.stubs.PsiJetObjectStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetObjectStubImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JetObjectElementType
extends JetStubElementType<PsiJetObjectStub, JetObjectDeclaration> {
    public JetObjectElementType(@NotNull @NonNls String debugName) {
        super(debugName);
    }

    @Override
    public JetObjectDeclaration createPsiFromAst(@NotNull ASTNode node) {
        return new JetObjectDeclaration(node);
    }

    @Override
    public JetObjectDeclaration createPsi(@NotNull PsiJetObjectStub stub) {
        return new JetObjectDeclaration(stub);
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psiElement;
        if (super.shouldCreateStub(node) && (psiElement = node.getPsi()) instanceof JetObjectDeclaration) {
            JetObjectDeclaration objectDeclaration = (JetObjectDeclaration)psiElement;
            return objectDeclaration.getName() != null || JetObjectElementType.isClassObject(objectDeclaration);
        }
        return false;
    }

    @Override
    public PsiJetObjectStub createStub(@NotNull JetObjectDeclaration psi, @NotNull StubElement parentStub) {
        String name = psi.getName();
        FqName fqName = psi.getFqName();
        return new PsiJetObjectStubImpl((IStubElementType)JetStubElementTypes.OBJECT_DECLARATION, parentStub, name, fqName, psi.isTopLevel(), JetObjectElementType.isClassObject(psi));
    }

    @Override
    public void serialize(PsiJetObjectStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        FqName fqName = stub.getFqName();
        dataStream.writeName(fqName != null ? fqName.toString() : null);
        dataStream.writeBoolean(stub.isTopLevel());
        dataStream.writeBoolean(stub.isClassObject());
    }

    @Override
    public PsiJetObjectStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        StringRef fqNameStr = dataStream.readName();
        FqName fqName = fqNameStr != null ? new FqName(fqNameStr.toString()) : null;
        boolean isTopLevel = dataStream.readBoolean();
        boolean isClassObject = dataStream.readBoolean();
        return new PsiJetObjectStubImpl((IStubElementType)JetStubElementTypes.OBJECT_DECLARATION, parentStub, name, fqName, isTopLevel, isClassObject);
    }

    @Override
    public void indexStub(PsiJetObjectStub stub, IndexSink sink) {
        StubIndexServiceFactory.getInstance().indexObject(stub, sink);
    }

    private static boolean isClassObject(@NotNull JetObjectDeclaration objectDeclaration) {
        return objectDeclaration.getParent() instanceof JetClassObject;
    }
}

