/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.CallKey;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThisReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.CallTransformer;
import org.jetbrains.jet.lang.resolve.calls.CandidateResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.ResolveMode;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionDebugInfo;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionResultsHandler;
import org.jetbrains.jet.lang.resolve.calls.tasks.CallableDescriptorCollectors;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.util.DelegatingCall;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.calls.util.JetFakeReference;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

public class CallResolver {
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private TypeResolver typeResolver;
    @NotNull
    private CandidateResolver candidateResolver;
    @NotNull
    private ArgumentTypeResolver argumentTypeResolver;
    @Nullable
    private CallResolverExtension extension;

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void setCandidateResolver(@NotNull CandidateResolver candidateResolver) {
        this.candidateResolver = candidateResolver;
    }

    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        this.argumentTypeResolver = argumentTypeResolver;
    }

    public void setExtension(@NotNull CallResolverExtension extension) {
        this.extension = extension;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context) {
        JetExpression calleeExpression = context.call.getCalleeExpression();
        assert (calleeExpression instanceof JetSimpleNameExpression);
        JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression.getReferencedNameAsName();
        ArrayList callableDescriptorCollectors = Lists.newArrayList();
        if (nameExpression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER) {
            referencedName = Name.identifier(referencedName.asString().substring(1));
            callableDescriptorCollectors.add(CallableDescriptorCollectors.PROPERTIES);
        } else {
            callableDescriptorCollectors.add(CallableDescriptorCollectors.VARIABLES);
        }
        List prioritizedTasks = TaskPrioritizer.computePrioritizedTasks(context, referencedName, nameExpression, callableDescriptorCollectors);
        return this.doResolveCallOrGetCachedResults(ResolutionResultsCache.PROPERTY_MEMBER_TYPE, context, prioritizedTasks, CallTransformer.PROPERTY_CALL_TRANSFORMER, nameExpression);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull BasicCallResolutionContext context, @NotNull JetReferenceExpression functionReference, @NotNull Name name) {
        List tasks = TaskPrioritizer.computePrioritizedTasks(context, name, functionReference, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES);
        return this.doResolveCallOrGetCachedResults(ResolutionResultsCache.FUNCTION_MEMBER_TYPE, context, tasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, functionReference);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo) {
        return this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope, call, expectedType, dataFlowInfo, ResolveMode.TOP_LEVEL_CALL, CheckValueArgumentsMode.ENABLED, ExpressionPosition.FREE, ResolutionResultsCache.create()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    OverloadResolutionResultsImpl<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context) {
        JetValueArgumentList reportAbsenceOn;
        void var4_9;
        List prioritizedTasks;
        ProgressIndicatorProvider.checkCanceled();
        JetExpression calleeExpression = context.call.getCalleeExpression();
        if (calleeExpression instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression expression;
            JetSimpleNameExpression jetSimpleNameExpression = expression = (JetSimpleNameExpression)calleeExpression;
            ExpressionTypingUtils.checkCapturingInClosure(expression, context.trace, context.scope);
            Name name = expression.getReferencedNameAsName();
            prioritizedTasks = TaskPrioritizer.computePrioritizedTasks(context, name, jetSimpleNameExpression, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES);
            ResolutionTask.DescriptorCheckStrategy abstractConstructorCheck = new ResolutionTask.DescriptorCheckStrategy(){

                @Override
                public <D extends CallableDescriptor> boolean performAdvancedChecks(D descriptor, BindingTrace trace, TracingStrategy tracing) {
                    Modality modality;
                    if (descriptor instanceof ConstructorDescriptor && (modality = ((ConstructorDescriptor)descriptor).getContainingDeclaration().getModality()) == Modality.ABSTRACT) {
                        tracing.instantiationOfAbstractClass(trace);
                        return false;
                    }
                    return true;
                }
            };
            Iterator i$ = prioritizedTasks.iterator();
            while (i$.hasNext()) {
                ResolutionTask task = i$.next();
                task.setCheckingStrategy(abstractConstructorCheck);
            }
            return this.doResolveCallOrGetCachedResults(ResolutionResultsCache.FUNCTION_MEMBER_TYPE, context, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, (JetReferenceExpression)var4_9);
        }
        JetValueArgumentList valueArgumentList = context.call.getValueArgumentList();
        PsiElement psiElement = reportAbsenceOn = valueArgumentList == null ? context.call.getCallElement() : valueArgumentList;
        if (calleeExpression instanceof JetConstructorCalleeExpression) {
            assert (!context.call.getExplicitReceiver().exists());
            JetConstructorCalleeExpression expression = (JetConstructorCalleeExpression)calleeExpression;
            JetReferenceExpression jetReferenceExpression = expression.getConstructorReferenceExpression();
            if (jetReferenceExpression == null) {
                return this.checkArgumentTypesAndFail(context);
            }
            JetTypeReference typeReference = expression.getTypeReference();
            assert (typeReference != null);
            JetType constructedType = this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
            if (ErrorUtils.isErrorType(constructedType)) {
                return this.checkArgumentTypesAndFail(context);
            }
            ClassifierDescriptor declarationDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                context.trace.report(Errors.NOT_A_CLASS.on(calleeExpression));
                return this.checkArgumentTypesAndFail(context);
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            Collection<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
            if (constructors.isEmpty()) {
                context.trace.report(Errors.NO_CONSTRUCTOR.on(reportAbsenceOn));
                return this.checkArgumentTypesAndFail(context);
            }
            Collection candidates = TaskPrioritizer.convertWithImpliedThis(context.scope, Collections.singletonList(ReceiverValue.NO_RECEIVER), constructors);
            prioritizedTasks = TaskPrioritizer.computePrioritizedTasksFromCandidates(context, jetReferenceExpression, candidates);
            return this.doResolveCallOrGetCachedResults(ResolutionResultsCache.FUNCTION_MEMBER_TYPE, context, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, (JetReferenceExpression)var4_9);
        }
        if (calleeExpression instanceof JetThisReferenceExpression) {
            JetThisReferenceExpression jetThisReferenceExpression = (JetThisReferenceExpression)calleeExpression;
            DeclarationDescriptor containingDeclaration = context.scope.getContainingDeclaration();
            if (containingDeclaration instanceof ConstructorDescriptor) {
                containingDeclaration = containingDeclaration.getContainingDeclaration();
            }
            assert (containingDeclaration instanceof ClassDescriptor);
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            Collection<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
            if (constructors.isEmpty()) {
                context.trace.report(Errors.NO_CONSTRUCTOR.on(reportAbsenceOn));
                return this.checkArgumentTypesAndFail(context);
            }
            List candidates = ResolutionCandidate.convertCollection(constructors, JetPsiUtil.isSafeCall(context.call));
            prioritizedTasks = Collections.singletonList(new ResolutionTask(candidates, jetThisReferenceExpression, context));
            return this.doResolveCallOrGetCachedResults(ResolutionResultsCache.FUNCTION_MEMBER_TYPE, context, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, (JetReferenceExpression)var4_9);
        }
        if (calleeExpression == null) return this.checkArgumentTypesAndFail(context);
        JetType calleeType = this.expressionTypingServices.safeGetType(context.scope, calleeExpression, TypeUtils.NO_EXPECTED_TYPE, context.dataFlowInfo, context.trace);
        if (!KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(calleeType)) {
            if (ErrorUtils.isErrorType(calleeType)) return this.checkArgumentTypesAndFail(context);
            context.trace.report(Errors.CALLEE_NOT_A_FUNCTION.on(calleeExpression, calleeType));
            return this.checkArgumentTypesAndFail(context);
        }
        ExpressionAsFunctionDescriptor functionDescriptor = new ExpressionAsFunctionDescriptor(context.scope.getContainingDeclaration(), Name.special("<for expression " + calleeExpression.getText() + ">"));
        FunctionDescriptorUtil.initializeFromFunctionType(functionDescriptor, calleeType, ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, Modality.FINAL, Visibilities.LOCAL);
        ResolutionCandidate<ExpressionAsFunctionDescriptor> resolutionCandidate = ResolutionCandidate.create(functionDescriptor, JetPsiUtil.isSafeCall(context.call));
        resolutionCandidate.setReceiverArgument(context.call.getExplicitReceiver());
        resolutionCandidate.setExplicitReceiverKind(ExplicitReceiverKind.RECEIVER_ARGUMENT);
        JetFakeReference jetFakeReference = new JetFakeReference(calleeExpression);
        prioritizedTasks = Collections.singletonList(new ResolutionTask(Collections.singleton(resolutionCandidate), jetFakeReference, context));
        return this.doResolveCallOrGetCachedResults(ResolutionResultsCache.FUNCTION_MEMBER_TYPE, context, prioritizedTasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, (JetReferenceExpression)var4_9);
    }

    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCallOrGetCachedResults(@NotNull ResolutionResultsCache.MemberType<F> memberType, @NotNull BasicCallResolutionContext context, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull JetReferenceExpression reference) {
        OverloadResolutionResultsImpl<F> cachedResults;
        OverloadResolutionResultsImpl<F> results = null;
        TracingStrategy tracing = prioritizedTasks.isEmpty() ? TracingStrategy.EMPTY : prioritizedTasks.iterator().next().tracing;
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context.trace, "trace to resolve call", context.call);
        CallKey callKey = CallResolverUtil.createCallKey(context);
        if (callKey != null && (cachedResults = context.resolutionResultsCache.getResolutionResults(callKey, memberType)) != null) {
            DelegatingBindingTrace deltasTraceForResolve = context.resolutionResultsCache.getResolutionTrace(callKey);
            assert (deltasTraceForResolve != null);
            deltasTraceForResolve.addAllMyDataTo(traceToResolveCall);
            results = cachedResults;
        }
        if (results == null) {
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)context.replaceBindingTrace(traceToResolveCall);
            results = this.doResolveCall(newContext, prioritizedTasks, callTransformer, reference);
            DelegatingBindingTrace deltasTraceForTypeInference = results.getTrace();
            if (deltasTraceForTypeInference != null) {
                deltasTraceForTypeInference.addAllMyDataTo(traceToResolveCall);
            }
            this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results, tracing);
            CallResolver.cacheResults(memberType, context, results, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (!prioritizedTasks.isEmpty() && context.resolveMode != ResolveMode.NESTED_CALL) {
            results = this.completeTypeInferenceDependentOnExpectedType(context, results, tracing);
        }
        if (this.extension != null) {
            this.extension.run(results, context);
        }
        return results;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (!results.isSingleResult()) {
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall().getCallToCompleteTypeArgumentInference(), context, tracing);
        this.candidateResolver.completeTypeInferenceDependentOnFunctionLiteralsForCall(candidateContext);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeTypeInferenceDependentOnExpectedType(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (results.isSingleResult()) {
            this.argumentTypeResolver.checkUnmappedArgumentTypes(context, results.getResultingCall().getCallToCompleteTypeArgumentInference().getUnmappedArguments());
        }
        if (!results.isSingleResult()) {
            return results;
        }
        ResolvedCallImpl resolvedCall = results.getResultingCall().getCallToCompleteTypeArgumentInference();
        if (!resolvedCall.hasIncompleteTypeParameters()) {
            CallCandidateResolutionContext callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(resolvedCall, context, tracing);
            this.candidateResolver.completeNestedCallsInference(callCandidateResolutionContext);
            this.candidateResolver.checkValueArgumentTypes(callCandidateResolutionContext);
            return results;
        }
        ResolvedCallImpl copy = CallResolverUtil.copy(resolvedCall, context);
        CallCandidateResolutionContext callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(copy, context, tracing);
        this.candidateResolver.completeTypeInferenceDependentOnExpectedTypeForCall(callCandidateResolutionContext, false);
        if (copy.getStatus().isSuccess()) {
            return OverloadResolutionResultsImpl.success(copy);
        }
        return OverloadResolutionResultsImpl.incompleteTypeInference(copy);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull ResolutionResultsCache.MemberType<F> memberType, @NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<F> results, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        CallKey callKey = CallResolverUtil.createCallKey(context);
        if (callKey == null) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(new BindingTraceContext().getBindingContext(), "delta trace for caching resolve of", context.call);
        traceToResolveCall.addAllMyDataTo(deltasTraceToCacheResolve);
        context.resolutionResultsCache.recordResolutionResults(callKey, memberType, results);
        context.resolutionResultsCache.recordResolutionTrace(callKey, deltasTraceToCacheResolve);
        if (results.isSingleResult() && memberType == ResolutionResultsCache.FUNCTION_MEMBER_TYPE) {
            CallCandidateResolutionContext callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall().getCallToCompleteTypeArgumentInference(), context, tracing);
            context.resolutionResultsCache.recordDeferredComputationForCall(callKey, callCandidateResolutionContext, memberType);
        }
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCall(@NotNull BasicCallResolutionContext context, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull JetReferenceExpression reference) {
        ResolutionDebugInfo.Data debugInfo = ResolutionDebugInfo.create();
        context.trace.record(ResolutionDebugInfo.RESOLUTION_DEBUG_INFO, context.call.getCallElement(), debugInfo);
        context.trace.record(BindingContext.RESOLUTION_SCOPE, context.call.getCalleeExpression(), context.scope);
        if (context.dataFlowInfo.hasTypeInfoConstraints()) {
            context.trace.record(BindingContext.NON_DEFAULT_EXPRESSION_DATA_FLOW, context.call.getCalleeExpression(), context.dataFlowInfo);
        }
        debugInfo.set(ResolutionDebugInfo.TASKS, prioritizedTasks);
        TemporaryBindingTrace traceForFirstNonemptyCandidateSet = null;
        OverloadResolutionResultsImpl<Object> resultsForFirstNonemptyCandidateSet = null;
        for (ResolutionTask<D, F> task : prioritizedTasks) {
            boolean updateResults;
            TemporaryBindingTrace taskTrace;
            OverloadResolutionResultsImpl<F> results = this.performResolutionGuardedForExtraFunctionLiteralArguments((ResolutionTask)task.replaceBindingTrace(taskTrace = TemporaryBindingTrace.create(context.trace, "trace to resolve a task for", task.reference)), callTransformer);
            if (results.isSuccess() || results.isAmbiguity()) {
                taskTrace.commit();
                if (results.isSuccess()) {
                    debugInfo.set(ResolutionDebugInfo.RESULT, results.getResultingCall());
                }
                this.resolveFunctionArguments(context, results);
                return results;
            }
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                results.setTrace(taskTrace);
                return results;
            }
            boolean bl = updateResults = traceForFirstNonemptyCandidateSet == null || resultsForFirstNonemptyCandidateSet.getResultCode() == OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER && results.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
            if (task.getCandidates().isEmpty() || results.isNothing() || !updateResults) continue;
            traceForFirstNonemptyCandidateSet = taskTrace;
            resultsForFirstNonemptyCandidateSet = results;
        }
        if (traceForFirstNonemptyCandidateSet != null) {
            traceForFirstNonemptyCandidateSet.commit();
            if (resultsForFirstNonemptyCandidateSet.isSingleResult()) {
                debugInfo.set(ResolutionDebugInfo.RESULT, resultsForFirstNonemptyCandidateSet.getResultingCall());
            }
            this.resolveFunctionArguments(context, resultsForFirstNonemptyCandidateSet);
        } else {
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
            this.argumentTypeResolver.checkTypesWithNoCallee(context, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        return resultsForFirstNonemptyCandidateSet != null ? resultsForFirstNonemptyCandidateSet : OverloadResolutionResultsImpl.nameNotFound();
    }

    private <D extends CallableDescriptor> OverloadResolutionResults<D> resolveFunctionArguments(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results) {
        if (results.isSingleResult()) {
            this.argumentTypeResolver.checkTypesForFunctionArguments(context, results.getResultingCall().getCallToCompleteTypeArgumentInference());
        } else {
            this.argumentTypeResolver.checkTypesForFunctionArgumentsWithNoCallee(context);
        }
        return results;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolutionGuardedForExtraFunctionLiteralArguments(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer) {
        OverloadResolutionResultsImpl<F> results = this.performResolution(task, callTransformer);
        ImmutableSet<OverloadResolutionResults.Code> someFailed = ImmutableSet.of(OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES, OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH);
        if (someFailed.contains((Object)results.getResultCode()) && !task.call.getFunctionLiteralArguments().isEmpty() && task.resolveMode == ResolveMode.TOP_LEVEL_CALL) {
            DelegatingCall callWithoutFLArgs = new DelegatingCall(task.call){

                @Override
                @NotNull
                public List<JetExpression> getFunctionLiteralArguments() {
                    return Collections.emptyList();
                }
            };
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(task.trace, "trace for resolution guarded for extra function literal arguments");
            ResolutionTask newTask = ((ResolutionTask)task.replaceBindingTrace(temporaryTrace)).replaceCall(callWithoutFLArgs);
            OverloadResolutionResultsImpl resultsWithFunctionLiteralsStripped = this.performResolution(newTask, callTransformer);
            if (resultsWithFunctionLiteralsStripped.isSuccess() || resultsWithFunctionLiteralsStripped.isAmbiguity()) {
                task.tracing.danglingFunctionLiteralArgumentSuspected(task.trace, task.call.getFunctionLiteralArguments());
            }
        }
        return results;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolution(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer) {
        for (ResolutionCandidate<D> resolutionCandidate : task.getCandidates()) {
            TemporaryBindingTrace candidateTrace = TemporaryBindingTrace.create(task.trace, "trace to resolve candidate");
            Collection<CallCandidateResolutionContext<D>> contexts = callTransformer.createCallContexts(resolutionCandidate, task, candidateTrace);
            for (CallCandidateResolutionContext<D> context : contexts) {
                this.candidateResolver.performResolutionForCandidateCall(context, task);
                task.tracing.bindReference(context.candidateCall.getTrace(), context.candidateCall);
                Collection<ResolvedCallWithTrace<F>> calls = callTransformer.transformCall(context, this, task);
                for (ResolvedCallWithTrace<F> call : calls) {
                    task.tracing.bindReference(call.getTrace(), call);
                    task.tracing.bindResolvedCall(call.getTrace(), call);
                    task.getResolvedCalls().add(call);
                }
            }
        }
        OverloadResolutionResultsImpl results = ResolutionResultsHandler.INSTANCE.computeResultAndReportErrors(task.trace, task.tracing, task.getResolvedCalls());
        if (!results.isSingleResult() && !results.isIncomplete()) {
            this.argumentTypeResolver.checkTypesWithNoCallee(task.toBasic());
        }
        return results;
    }
}

