/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;

public class ResolutionTaskHolder<D extends CallableDescriptor, F extends D> {
    private final JetReferenceExpression reference;
    private final BasicCallResolutionContext basicCallResolutionContext;
    private final PriorityProvider<ResolutionCandidate<D>> priorityProvider;
    private final boolean isSafeCall;
    private final Collection<Collection<ResolutionCandidate<D>>> candidatesList = Lists.newArrayList();
    private List<ResolutionTask<D, F>> tasks = null;

    public ResolutionTaskHolder(@NotNull JetReferenceExpression reference, @NotNull BasicCallResolutionContext basicCallResolutionContext, @NotNull PriorityProvider<ResolutionCandidate<D>> priorityProvider) {
        this.reference = reference;
        this.basicCallResolutionContext = basicCallResolutionContext;
        this.priorityProvider = priorityProvider;
        this.isSafeCall = JetPsiUtil.isSafeCall(basicCallResolutionContext.call);
    }

    public Collection<ResolutionCandidate<D>> setIsSafeCall(@NotNull Collection<ResolutionCandidate<D>> candidates) {
        for (ResolutionCandidate<D> candidate : candidates) {
            candidate.setSafeCall(this.isSafeCall);
        }
        return candidates;
    }

    public void addCandidates(@NotNull Collection<ResolutionCandidate<D>> candidates) {
        if (!candidates.isEmpty()) {
            this.candidatesList.add(this.setIsSafeCall(candidates));
        }
    }

    public void addCandidates(@NotNull List<Collection<ResolutionCandidate<D>>> candidatesList) {
        for (Collection<ResolutionCandidate<D>> candidates : candidatesList) {
            this.addCandidates(candidates);
        }
    }

    public List<ResolutionTask<D, F>> getTasks() {
        if (this.tasks == null) {
            this.tasks = Lists.newArrayList();
            for (int priority = this.priorityProvider.getMaxPriority(); priority >= 0; --priority) {
                final int finalPriority = priority;
                for (Collection<ResolutionCandidate<D>> candidates : this.candidatesList) {
                    Collection<ResolutionCandidate<D>> filteredCandidates = Collections2.filter(candidates, new Predicate<ResolutionCandidate<D>>(){

                        @Override
                        public boolean apply(@Nullable ResolutionCandidate<D> input) {
                            return finalPriority == ResolutionTaskHolder.this.priorityProvider.getPriority(input);
                        }
                    });
                    if (filteredCandidates.isEmpty()) continue;
                    this.tasks.add(new ResolutionTask(filteredCandidates, this.reference, this.basicCallResolutionContext));
                }
            }
        }
        return this.tasks;
    }

    public static interface PriorityProvider<D> {
        public int getPriority(D var1);

        public int getMaxPriority();
    }
}

