/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class SignaturesUtil {
    public static Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> recreateTypeParametersAndReturnMapping(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        LinkedHashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl> result = Maps.newLinkedHashMap();
        for (TypeParameterDescriptor typeParameter : originalParameters) {
            result.put(typeParameter, TypeParameterDescriptorImpl.createForFurtherModification(newOwner == null ? typeParameter.getContainingDeclaration() : newOwner, typeParameter.getAnnotations(), typeParameter.isReified(), typeParameter.getVariance(), typeParameter.getName(), typeParameter.getIndex()));
        }
        return result;
    }

    public static TypeSubstitutor createSubstitutorForTypeParameters(@NotNull Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters) {
        HashMap<TypeConstructor, TypeProjection> typeSubstitutionContext = Maps.newHashMap();
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameter : originalToAltTypeParameters.entrySet()) {
            typeSubstitutionContext.put(originalToAltTypeParameter.getKey().getTypeConstructor(), new TypeProjection(originalToAltTypeParameter.getValue().getDefaultType()));
        }
        return TypeSubstitutor.create(typeSubstitutionContext);
    }

    private SignaturesUtil() {
    }
}

