/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.sam;

import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.resolve.ExternalOverridabilityCondition;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;

public class SamAdapterOverridabilityCondition
implements ExternalOverridabilityCondition {
    @Override
    public boolean isOverridable(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (subDescriptor instanceof PropertyDescriptor) {
            return true;
        }
        SimpleFunctionDescriptor superOriginal = SamAdapterOverridabilityCondition.getOriginalOfSamAdapterFunction((SimpleFunctionDescriptor)superDescriptor);
        SimpleFunctionDescriptor subOriginal = SamAdapterOverridabilityCondition.getOriginalOfSamAdapterFunction((SimpleFunctionDescriptor)subDescriptor);
        if (superOriginal == null || subOriginal == null) {
            return subOriginal == null;
        }
        return SamAdapterOverridabilityCondition.equalErasure(superOriginal, subOriginal);
    }

    private static boolean equalErasure(@NotNull FunctionDescriptor fun1, @NotNull FunctionDescriptor fun2) {
        List<ValueParameterDescriptor> parameters1 = fun1.getValueParameters();
        List<ValueParameterDescriptor> parameters2 = fun2.getValueParameters();
        for (ValueParameterDescriptor param1 : parameters1) {
            ValueParameterDescriptor param2 = parameters2.get(param1.getIndex());
            if (TypeUtils.equalClasses(param2.getType(), param1.getType())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static SimpleFunctionDescriptor getOriginalOfSamAdapterFunction(@NotNull SimpleFunctionDescriptor callable) {
        DeclarationDescriptor containingDeclaration = callable.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return null;
        }
        Pair<SimpleFunctionDescriptor, JetType> declarationOrSynthesized = SamAdapterOverridabilityCondition.getNearestDeclarationOrSynthesized(callable, ((ClassDescriptor)containingDeclaration).getDefaultType());
        if (declarationOrSynthesized == null) {
            return null;
        }
        SimpleFunctionDescriptor fun = (SimpleFunctionDescriptor)declarationOrSynthesized.first;
        if (fun.getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return null;
        }
        SimpleFunctionDescriptor originalOfSynthesized = ((SimpleFunctionDescriptorImpl)fun.getOriginal()).getOriginalOfSynthesized();
        if (originalOfSynthesized == null) {
            return null;
        }
        return (SimpleFunctionDescriptor)originalOfSynthesized.substitute(TypeSubstitutor.create((JetType)declarationOrSynthesized.second));
    }

    @Nullable
    private static Pair<SimpleFunctionDescriptor, JetType> getNearestDeclarationOrSynthesized(@NotNull SimpleFunctionDescriptor samAdapter, @NotNull JetType ownerType) {
        if (samAdapter.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return Pair.create(samAdapter, ownerType);
        }
        for (FunctionDescriptor functionDescriptor : samAdapter.getOverriddenDescriptors()) {
            ClassDescriptor containingClass = (ClassDescriptor)functionDescriptor.getContainingDeclaration();
            for (JetType immediateSupertype : TypeUtils.getImmediateSupertypes(ownerType)) {
                Pair<SimpleFunctionDescriptor, JetType> found;
                if (containingClass != immediateSupertype.getConstructor().getDeclarationDescriptor() || (found = SamAdapterOverridabilityCondition.getNearestDeclarationOrSynthesized((SimpleFunctionDescriptor)functionDescriptor, immediateSupertype)) == null) continue;
                return found;
            }
        }
        return null;
    }
}

