/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Profiler {
    private static final ThreadLocal<Stack<Profiler>> PROFILERS = new ThreadLocal<Stack<Profiler>>(){

        @Override
        protected Stack<Profiler> initialValue() {
            return new Stack<Profiler>();
        }
    };
    private static final ReentrantLock OUT_LOCK = new ReentrantLock();
    private final String name;
    private final PrintStream out;
    private long start = Long.MAX_VALUE;
    private long cumulative = 0L;
    private boolean paused = true;
    private StackTraceElement[] stackTrace;
    private boolean mute;

    @NotNull
    public static Profiler create(@NotNull String name) {
        return Profiler.create(name, null);
    }

    @NotNull
    public static Profiler create(@NotNull String name, @Nullable PrintStream out) {
        Profiler profiler = new Profiler(name, out);
        PROFILERS.get().push(profiler);
        return profiler;
    }

    public static Profiler getFromContext() {
        Stack<Profiler> profilers = PROFILERS.get();
        if (profilers.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return profilers.peek();
    }

    private Profiler(@NotNull String name, @Nullable PrintStream out) {
        this.name = name;
        this.out = out == null ? System.out : out;
    }

    public Profiler recordStackTrace(int depth) {
        return this.recordStackTrace(1, depth);
    }

    public Profiler recordStackTrace(int skip, int depth) {
        int from = 1 + skip;
        StackTraceElement[] trace = new Throwable().getStackTrace();
        if (from >= trace.length) {
            return this;
        }
        int to = depth == -1 ? trace.length : Math.min(skip + depth + 1, trace.length);
        this.stackTrace = Arrays.copyOfRange(trace, from, to);
        return this;
    }

    public Profiler resetStackTrace() {
        this.stackTrace = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler printStackTrace() {
        if (this.stackTrace != null) {
            OUT_LOCK.lock();
            try {
                for (StackTraceElement element : this.stackTrace) {
                    this.println("\tat ", element);
                }
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    public Profiler printEntering() {
        this.println("Entering ", this.name);
        return this;
    }

    public Profiler start() {
        if (this.paused) {
            this.start = System.nanoTime();
            this.paused = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler end() {
        long result = this.cumulative;
        if (!this.paused) {
            result += System.nanoTime() - this.start;
        }
        this.paused = true;
        this.cumulative = 0L;
        OUT_LOCK.lock();
        try {
            this.println(this.name, " took ", Profiler.format(result));
            this.printStackTrace();
        }
        finally {
            OUT_LOCK.unlock();
        }
        return this;
    }

    public Profiler pause() {
        if (!this.paused) {
            this.cumulative += System.nanoTime() - this.start;
            this.paused = true;
        }
        return this;
    }

    public Profiler mute() {
        this.mute = true;
        return this;
    }

    public Profiler unmute() {
        this.mute = false;
        return this;
    }

    public Profiler println(Object message) {
        if (!this.mute) {
            this.out.println(message);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler println(Object a, Object b) {
        if (!this.mute) {
            OUT_LOCK.lock();
            try {
                this.out.print(a);
                this.out.println(b);
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler println(Object a, Object b, Object c) {
        if (!this.mute) {
            OUT_LOCK.lock();
            try {
                this.out.print(a);
                this.out.print(b);
                this.out.println(c);
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler println(Object a, Object b, Object c, Object ... rest) {
        if (!this.mute) {
            OUT_LOCK.lock();
            try {
                this.out.print(a);
                this.out.print(b);
                this.out.print(c);
                for (Object o : rest) {
                    this.out.print(o);
                }
                this.out.println();
            }
            finally {
                OUT_LOCK.unlock();
            }
        }
        return this;
    }

    private static String format(long delta) {
        return String.format("%.3fs", (double)delta / 1.0E9);
    }
}

