/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.common.collect.Maps;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsScope;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class StandardClasses {
    @NotNull
    private final JsScope kotlinScope;
    @NotNull
    private final Map<FqNameUnsafe, JsName> standardObjects = Maps.newHashMap();
    @NotNull
    private final Map<FqNameUnsafe, JsScope> scopeMap = Maps.newHashMap();

    @NotNull
    public static StandardClasses bindImplementations(@NotNull JsScope kotlinObjectScope) {
        StandardClasses standardClasses = new StandardClasses(kotlinObjectScope);
        StandardClasses.declareJetObjects(standardClasses);
        return standardClasses;
    }

    private static void declareJetObjects(@NotNull StandardClasses standardClasses) {
        standardClasses.declare().forFQ("jet.Iterator").kotlinClass("Iterator").methods("next").properties("hasNext");
        standardClasses.declare().forFQ("jet.IntRange").kotlinClass("NumberRange").methods("iterator", "contains").properties("start", "end", "increment");
        standardClasses.declare().forFQ("jet.IntProgression").kotlinClass("NumberProgression").methods("iterator", "contains").properties("start", "end", "increment");
        standardClasses.declare().forFQ("jet.Enum").kotlinClass("Enum");
    }

    private StandardClasses(@NotNull JsScope kotlinScope) {
        this.kotlinScope = kotlinScope;
    }

    private void declareTopLevelObjectInScope(@NotNull JsScope scope, @NotNull Map<FqNameUnsafe, JsName> map, @NotNull FqNameUnsafe fullQualifiedName, @NotNull String name) {
        JsName declaredName = scope.declareName(name);
        map.put(fullQualifiedName, declaredName);
        this.scopeMap.put(fullQualifiedName, new JsScope(scope, "scope for " + name));
    }

    private void declareKotlinObject(@NotNull FqNameUnsafe fullQualifiedName, @NotNull String kotlinLibName) {
        this.declareTopLevelObjectInScope(this.kotlinScope, this.standardObjects, fullQualifiedName, kotlinLibName);
    }

    private void declareInner(@NotNull FqNameUnsafe fullQualifiedClassName, @NotNull String shortMethodName, @NotNull String javascriptName) {
        JsScope classScope = this.scopeMap.get(fullQualifiedClassName);
        assert (classScope != null);
        FqNameUnsafe fullQualifiedMethodName = fullQualifiedClassName.child(Name.guess(shortMethodName));
        this.standardObjects.put(fullQualifiedMethodName, classScope.declareName(javascriptName));
    }

    private void declareMethods(@NotNull FqNameUnsafe classFQName, String ... methodNames) {
        for (String methodName : methodNames) {
            this.declareInner(classFQName, methodName, methodName);
        }
    }

    private void declareReadonlyProperties(@NotNull FqNameUnsafe classFQName, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.declareInner(classFQName, propertyName, propertyName);
        }
    }

    public boolean isStandardObject(@NotNull DeclarationDescriptor descriptor) {
        return this.standardObjects.containsKey(DescriptorUtils.getFQName(descriptor));
    }

    @NotNull
    public JsName getStandardObjectName(@NotNull DeclarationDescriptor descriptor) {
        return this.standardObjects.get(DescriptorUtils.getFQName(descriptor));
    }

    @NotNull
    private Builder declare() {
        return new Builder();
    }

    private final class Builder {
        @Nullable
        private FqNameUnsafe currentFQName = null;
        @Nullable
        private String currentObjectName = null;

        private Builder() {
        }

        @NotNull
        public Builder forFQ(@NotNull String classFQName) {
            this.currentFQName = new FqNameUnsafe(classFQName);
            return this;
        }

        @NotNull
        public Builder kotlinClass(@NotNull String kotlinName) {
            this.kotlinTopLevelObject(kotlinName);
            this.constructor();
            return this;
        }

        private void kotlinTopLevelObject(@NotNull String kotlinName) {
            assert (this.currentFQName != null);
            this.currentObjectName = kotlinName;
            StandardClasses.this.declareKotlinObject(this.currentFQName, kotlinName);
        }

        @NotNull
        private Builder constructor() {
            assert (this.currentFQName != null);
            assert (this.currentObjectName != null);
            StandardClasses.this.declareInner(this.currentFQName, "<init>", this.currentObjectName);
            return this;
        }

        @NotNull
        public Builder methods(String ... methodNames) {
            assert (this.currentFQName != null);
            StandardClasses.this.declareMethods(this.currentFQName, methodNames);
            return this;
        }

        @NotNull
        public Builder properties(String ... propertyNames) {
            assert (this.currentFQName != null);
            StandardClasses.this.declareReadonlyProperties(this.currentFQName, propertyNames);
            return this;
        }
    }
}

