/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.Named;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.declaration.PropertyTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.general.TranslatorVisitor;
import org.jetbrains.k2js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public class DeclarationBodyVisitor
extends TranslatorVisitor<Void> {
    protected final List<JsPropertyInitializer> result;
    protected final List<JsPropertyInitializer> staticResult;
    protected final List<JsPropertyInitializer> enumEntryList = new SmartList<JsPropertyInitializer>();

    public DeclarationBodyVisitor() {
        this(new SmartList<JsPropertyInitializer>(), new SmartList<JsPropertyInitializer>());
    }

    public DeclarationBodyVisitor(@NotNull List<JsPropertyInitializer> result, @NotNull List<JsPropertyInitializer> staticResult) {
        this.result = result;
        this.staticResult = staticResult;
    }

    @NotNull
    public List<JsPropertyInitializer> getResult() {
        return this.result;
    }

    public List<JsPropertyInitializer> getEnumEntryList() {
        return this.enumEntryList;
    }

    @Override
    public Void visitClass(@NotNull JetClass expression, @NotNull TranslationContext context) {
        return null;
    }

    @Override
    public Void visitEnumEntry(final JetEnumEntry enumEntry, TranslationContext data) {
        JsExpression jsEnumEntryCreation;
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(data.bindingContext(), enumEntry);
        Collection<JetType> supertypes = descriptor.getTypeConstructor().getSupertypes();
        if (enumEntry.getBody() != null || supertypes.size() > 1) {
            jsEnumEntryCreation = ClassTranslator.generateClassCreation(enumEntry, descriptor, data);
        } else {
            assert (supertypes.size() == 1) : "Simple Enum entry must have one supertype";
            jsEnumEntryCreation = new ClassInitializerTranslator(enumEntry, data).generateEnumEntryInstanceCreation(supertypes.iterator().next());
        }
        Named named = new Named(){

            @Override
            @NotNull
            public Name getName() {
                String name = enumEntry.getName();
                assert (name != null) : "Enum entry name must be not null";
                return Name.identifier(name);
            }
        };
        this.enumEntryList.add(new JsPropertyInitializer(data.nameToLiteral(named), jsEnumEntryCreation));
        return null;
    }

    @Override
    public Void visitClassObject(JetClassObject classObject, TranslationContext context) {
        JetObjectDeclaration declaration = classObject.getObjectDeclaration();
        assert (declaration != null) : "Declaration for class object must be not null";
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(context.bindingContext(), declaration);
        JsExpression value = ClassTranslator.generateClassCreation(declaration, descriptor, context);
        JsFunction fun = TranslationUtils.simpleReturnFunction(context.getScopeForDescriptor(descriptor), value);
        this.staticResult.add(InitializerUtils.createPropertyInitializer(Namer.getNamedForClassObjectInitializer(), fun, context));
        return null;
    }

    @Override
    public Void visitNamedFunction(@NotNull JetNamedFunction expression, @NotNull TranslationContext context) {
        FunctionDescriptor descriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression);
        if (descriptor.getModality() == Modality.ABSTRACT) {
            return null;
        }
        JsPropertyInitializer methodAsPropertyInitializer = Translation.functionTranslator(expression, context).translateAsMethod();
        if (context.isEcma5()) {
            JsExpression methodBodyExpression = methodAsPropertyInitializer.getValueExpr();
            methodAsPropertyInitializer.setValueExpr(JsAstUtils.createPropertyDataDescriptor(descriptor, methodBodyExpression));
        }
        this.result.add(methodAsPropertyInitializer);
        return null;
    }

    @Override
    public Void visitProperty(@NotNull JetProperty expression, @NotNull TranslationContext context) {
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context.bindingContext(), expression);
        PropertyTranslator.translateAccessors(propertyDescriptor, expression, this.result, context);
        return null;
    }

    @Override
    public Void visitObjectDeclarationName(@NotNull JetObjectDeclarationName expression, @NotNull TranslationContext context) {
        if (!context.isEcma5()) {
            PropertyTranslator.translateAccessors(BindingUtils.getPropertyDescriptorForObjectDeclaration(context.bindingContext(), expression), this.result, context);
        }
        return null;
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull JetClassInitializer expression, @NotNull TranslationContext context) {
        return null;
    }
}

