/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;

abstract class InnerDeclarationTranslator {
    protected final TranslationContext context;
    protected final JsFunction fun;

    public InnerDeclarationTranslator(@NotNull TranslationContext context, @NotNull JsFunction fun) {
        this.context = context;
        this.fun = fun;
    }

    public JsExpression translate(@NotNull JsNameRef nameRef, @Nullable JsExpression self) {
        boolean hasCaptured = this.context.usageTracker().hasCaptured();
        if (!hasCaptured && self == JsLiteral.NULL) {
            return this.createExpression(nameRef, self);
        }
        JsInvocation invocation = this.createInvocation(nameRef, self);
        if (hasCaptured) {
            final List<JsExpression> expressions = invocation.getArguments();
            this.context.usageTracker().forEachCaptured(new Consumer<CallableDescriptor>(){

                @Override
                public void consume(CallableDescriptor descriptor) {
                    JsName name;
                    if (descriptor instanceof VariableDescriptor) {
                        name = InnerDeclarationTranslator.this.context.getNameForDescriptor(descriptor);
                    } else {
                        name = ((JsNameRef)InnerDeclarationTranslator.this.context.getAliasForDescriptor(descriptor)).getName();
                        assert (name != null);
                    }
                    InnerDeclarationTranslator.this.fun.getParameters().add(new JsParameter(name));
                    expressions.add(name.makeRef());
                }
            });
        }
        return invocation;
    }

    protected abstract JsExpression createExpression(@NotNull JsNameRef var1, @Nullable JsExpression var2);

    protected abstract JsInvocation createInvocation(@NotNull JsNameRef var1, @Nullable JsExpression var2);
}

