/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;
import org.jetbrains.k2js.translate.utils.mutator.AssignToExpressionMutator;
import org.jetbrains.k2js.translate.utils.mutator.LastExpressionMutator;

public final class WhenTranslator
extends AbstractTranslator {
    @NotNull
    private final JetWhenExpression whenExpression;
    @Nullable
    private final Pair<JsVars.JsVar, JsExpression> expressionToMatch;
    @Nullable
    private Pair<JsVars.JsVar, JsExpression> result;

    @Nullable
    public static JsNode translate(@NotNull JetWhenExpression expression, @NotNull TranslationContext context) {
        WhenTranslator translator = new WhenTranslator(expression, context);
        if (BindingUtils.isStatement(context.bindingContext(), expression)) {
            translator.translateAsStatement(context.dynamicContext().jsBlock().getStatements());
            return null;
        }
        return translator.translateAsExpression();
    }

    private WhenTranslator(@NotNull JetWhenExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.whenExpression = expression;
        JetExpression subject = expression.getSubjectExpression();
        this.expressionToMatch = subject != null ? TranslationUtils.createTemporaryIfNeed(Translation.translateAsExpression(subject, this.context()), context) : null;
    }

    @Nullable
    private JsNode translateAsExpression() {
        this.result = this.context().dynamicContext().createTemporary(null);
        this.translateAsStatement(this.context().dynamicContext().jsBlock().getStatements());
        return (JsNode)this.result.second;
    }

    private void translateAsStatement(List<JsStatement> statements) {
        this.addTempVarsStatement(statements);
        JsIf prevIf = null;
        for (JetWhenEntry entry : this.whenExpression.getEntries()) {
            JsStatement statement = this.withReturnValueCaptured(this.translateEntryExpression(entry));
            if (entry.isElse()) {
                if (prevIf == null) {
                    statements.add(statement);
                    break;
                }
                prevIf.setElseStatement(statement);
                break;
            }
            JsIf ifStatement = new JsIf(this.translateConditions(entry), statement);
            if (prevIf == null) {
                statements.add(ifStatement);
            } else {
                prevIf.setElseStatement(ifStatement);
            }
            prevIf = ifStatement;
        }
    }

    private void addTempVarsStatement(List<JsStatement> statements) {
        JsVars vars = new JsVars();
        if (this.expressionToMatch != null && this.expressionToMatch.first != null) {
            vars.add((JsVars.JsVar)this.expressionToMatch.first);
        }
        if (this.result != null) {
            vars.add((JsVars.JsVar)this.result.first);
        }
        if (!vars.isEmpty()) {
            statements.add(vars);
        }
    }

    @NotNull
    private JsStatement withReturnValueCaptured(@NotNull JsNode node) {
        return this.result == null ? JsAstUtils.convertToStatement(node) : LastExpressionMutator.mutateLastExpression(node, new AssignToExpressionMutator((JsExpression)this.result.second));
    }

    @NotNull
    private JsNode translateEntryExpression(@NotNull JetWhenEntry entry) {
        JetExpression expressionToExecute = entry.getExpression();
        assert (expressionToExecute != null) : "WhenEntry should have whenExpression to execute.";
        return Translation.translateExpression(expressionToExecute, this.context());
    }

    @NotNull
    private JsExpression translateConditions(@NotNull JetWhenEntry entry) {
        JetWhenCondition[] conditions = entry.getConditions();
        assert (conditions.length > 0) : "When entry (not else) should have at least one condition";
        if (conditions.length == 1) {
            return this.translateCondition(conditions[0]);
        }
        JsExpression result = this.translateCondition(conditions[0]);
        for (int i = 1; i < conditions.length; ++i) {
            result = new JsBinaryOperation(JsBinaryOperator.OR, this.translateCondition(conditions[i]), result);
        }
        return result;
    }

    @NotNull
    private JsExpression translateCondition(@NotNull JetWhenCondition condition) {
        if (condition instanceof JetWhenConditionIsPattern || condition instanceof JetWhenConditionWithExpression) {
            return this.translatePatternCondition(condition);
        }
        throw new AssertionError((Object)("Unsupported when condition " + condition.getClass()));
    }

    @NotNull
    private JsExpression translatePatternCondition(@NotNull JetWhenCondition condition) {
        JsExpression patternMatchExpression = this.translateWhenConditionToBooleanExpression(condition);
        if (WhenTranslator.isNegated(condition)) {
            return JsAstUtils.negated(patternMatchExpression);
        }
        return patternMatchExpression;
    }

    @NotNull
    private JsExpression translateWhenConditionToBooleanExpression(@NotNull JetWhenCondition condition) {
        if (condition instanceof JetWhenConditionIsPattern) {
            return this.translateIsCondition((JetWhenConditionIsPattern)condition);
        }
        if (condition instanceof JetWhenConditionWithExpression) {
            return this.translateExpressionCondition((JetWhenConditionWithExpression)condition);
        }
        throw new AssertionError((Object)"Wrong type of JetWhenCondition");
    }

    @NotNull
    private JsExpression translateIsCondition(@NotNull JetWhenConditionIsPattern conditionIsPattern) {
        JsExpression expressionToMatch = this.getExpressionToMatch();
        assert (expressionToMatch != null) : "An is-check is not allowed in when() without subject.";
        JetTypeReference typeReference = conditionIsPattern.getTypeRef();
        assert (typeReference != null) : "An is-check must have a type reference.";
        return Translation.patternTranslator(this.context()).translateIsCheck(expressionToMatch, typeReference);
    }

    @NotNull
    private JsExpression translateExpressionCondition(@NotNull JetWhenConditionWithExpression condition) {
        JetExpression patternExpression = condition.getExpression();
        assert (patternExpression != null) : "Expression pattern should have an expression.";
        JsExpression expressionToMatch = this.getExpressionToMatch();
        if (expressionToMatch == null) {
            return Translation.patternTranslator(this.context()).translateExpressionForExpressionPattern(patternExpression);
        }
        return Translation.patternTranslator(this.context()).translateExpressionPattern(expressionToMatch, patternExpression);
    }

    @Nullable
    private JsExpression getExpressionToMatch() {
        return this.expressionToMatch != null ? (JsExpression)this.expressionToMatch.second : null;
    }

    private static boolean isNegated(@NotNull JetWhenCondition condition) {
        if (condition instanceof JetWhenConditionIsPattern) {
            return ((JetWhenConditionIsPattern)condition).isNegated();
        }
        return false;
    }
}

