/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedPropertyAccessTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;

public final class KotlinPropertyAccessTranslator
extends PropertyAccessTranslator {
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final PropertyDescriptor propertyDescriptor;
    @NotNull
    private final ResolvedCall<?> resolvedCall;

    KotlinPropertyAccessTranslator(@NotNull PropertyDescriptor descriptor, @Nullable JsExpression receiver, @NotNull ResolvedCall<?> resolvedCall, @NotNull TranslationContext context) {
        super(context);
        this.receiver = receiver;
        this.propertyDescriptor = descriptor.getOriginal();
        this.resolvedCall = resolvedCall;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.translateAsGet(this.receiver);
    }

    @Override
    @NotNull
    public JsExpression translateAsGet(@Nullable JsExpression receiver) {
        PropertyGetterDescriptor getter = this.propertyDescriptor.getGetter();
        if (getter == null) {
            PropertyGetterDescriptorImpl getterImpl = DescriptorResolver.createDefaultGetter(this.propertyDescriptor);
            getterImpl.initialize(this.propertyDescriptor.getType());
            ((PropertyDescriptorImpl)this.propertyDescriptor).initialize(getterImpl, null);
            getter = getterImpl;
        }
        assert (getter != null) : "Getter for kotlin properties should bot be null.";
        return this.callBuilderForAccessor(receiver).descriptor(getter).translate();
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        return this.translateAsSet(this.receiver, toSetTo);
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@Nullable JsExpression receiver, @NotNull JsExpression toSetTo) {
        PropertySetterDescriptor setter = this.propertyDescriptor.getSetter();
        assert (setter != null) : "Setter for kotlin properties should not be null.";
        return this.callBuilderForAccessor(receiver).args(toSetTo).descriptor(setter).translate();
    }

    @NotNull
    private CallBuilder callBuilderForAccessor(@Nullable JsExpression qualifier) {
        return CallBuilder.build(this.context()).receiver(qualifier).resolvedCall(this.resolvedCall).type(this.getCallType());
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        return new CachedPropertyAccessTranslator(this.receiver, this, this.context());
    }
}

