/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class InferenceGraphNode<T> {
    private final List<T> myValue = new ArrayList<T>();
    private Set<InferenceGraphNode<T>> myDependencies = new HashSet<InferenceGraphNode<T>>();
    private int index = -1;
    private int lowlink;

    public InferenceGraphNode(T value) {
        this.myValue.add(value);
    }

    public List<T> getValue() {
        return this.myValue;
    }

    public Set<InferenceGraphNode<T>> getDependencies() {
        return this.myDependencies;
    }

    public void addDependency(InferenceGraphNode<T> node) {
        this.myDependencies.add(node);
    }

    public static <T> List<List<InferenceGraphNode<T>>> tarjan(Collection<InferenceGraphNode<T>> nodes) {
        ArrayList<List<InferenceGraphNode<T>>> result = new ArrayList<List<InferenceGraphNode<T>>>();
        Stack<InferenceGraphNode<T>> currentStack = new Stack<InferenceGraphNode<T>>();
        int index = 0;
        for (InferenceGraphNode<T> node : nodes) {
            if (node.index != -1) continue;
            index += InferenceGraphNode.strongConnect(node, index, currentStack, result);
        }
        return result;
    }

    public static <T> ArrayList<InferenceGraphNode<T>> initNodes(Collection<InferenceGraphNode<T>> allNodes) {
        List<List<InferenceGraphNode<T>>> nodes = InferenceGraphNode.tarjan(allNodes);
        ArrayList<InferenceGraphNode<T>> acyclicNodes = new ArrayList<InferenceGraphNode<T>>();
        for (List<InferenceGraphNode<T>> cycle : nodes) {
            acyclicNodes.add(InferenceGraphNode.merge(cycle, allNodes));
        }
        return acyclicNodes;
    }

    private static <T> InferenceGraphNode<T> merge(List<InferenceGraphNode<T>> cycle, Collection<InferenceGraphNode<T>> allNodes) {
        assert (!cycle.isEmpty());
        InferenceGraphNode<T> root = cycle.get(0);
        if (cycle.size() > 1) {
            for (int i = 1; i < cycle.size(); ++i) {
                InferenceGraphNode<T> cycleNode = cycle.get(i);
                super.copyFrom(cycleNode);
                super.filterInterCycleDependencies();
                for (InferenceGraphNode<T> node : allNodes) {
                    if (!node.myDependencies.remove(cycleNode)) continue;
                    node.myDependencies.add(root);
                }
            }
        }
        return root;
    }

    private void filterInterCycleDependencies() {
        boolean includeSelfDependency = false;
        Iterator<InferenceGraphNode<T>> iterator = this.myDependencies.iterator();
        while (iterator.hasNext()) {
            InferenceGraphNode<T> d = iterator.next();
            assert (d.myValue.size() >= 1);
            T initialNodeValue = d.myValue.get(0);
            if (!this.myValue.contains(initialNodeValue)) continue;
            includeSelfDependency = true;
            iterator.remove();
        }
        if (includeSelfDependency) {
            this.myDependencies.add(this);
        }
    }

    private void copyFrom(InferenceGraphNode<T> cycleNode) {
        this.myValue.addAll(cycleNode.myValue);
        this.myDependencies.addAll(cycleNode.myDependencies);
    }

    private static <T> int strongConnect(InferenceGraphNode<T> currentNode, int index, Stack<InferenceGraphNode<T>> currentStack, ArrayList<List<InferenceGraphNode<T>>> result) {
        currentNode.index = index;
        currentNode.lowlink = index++;
        currentStack.push(currentNode);
        for (InferenceGraphNode<T> dependantNode : currentNode.getDependencies()) {
            if (dependantNode.index == -1) {
                InferenceGraphNode.strongConnect(dependantNode, index, currentStack, result);
                currentNode.lowlink = Math.min(currentNode.lowlink, dependantNode.lowlink);
                continue;
            }
            if (!currentStack.contains(dependantNode)) continue;
            currentNode.lowlink = Math.min(currentNode.lowlink, dependantNode.index);
        }
        if (currentNode.lowlink == currentNode.index) {
            InferenceGraphNode<T> cyclicNode;
            ArrayList<InferenceGraphNode<T>> arrayList = new ArrayList<InferenceGraphNode<T>>();
            do {
                cyclicNode = currentStack.pop();
                arrayList.add(cyclicNode);
            } while (cyclicNode != currentNode);
            result.add(arrayList);
        }
        return index;
    }
}

