/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ConcurrentHashSet<K>
implements Set<K> {
    private final ConcurrentMap<K, Boolean> map = new ConcurrentHashMap<K, Boolean>();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    @NotNull
    public Iterator<K> iterator() {
        Iterator iterator = this.map.keySet().iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentHashSet", "iterator"));
        }
        return iterator;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.map.keySet().toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentHashSet", "toArray"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentHashSet", "toArray"));
        }
        T[] TArray = this.map.keySet().toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentHashSet", "toArray"));
        }
        return TArray;
    }

    @Override
    public boolean add(K o) {
        return this.map.putIfAbsent(o, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.keySet().remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentHashSet", "containsAll"));
        }
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends K> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentHashSet", "addAll"));
        }
        boolean ret = false;
        for (K o : c) {
            ret |= this.add(o);
        }
        return ret;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentHashSet", "retainAll"));
        }
        return this.map.keySet().retainAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentHashSet", "removeAll"));
        }
        return this.map.keySet().removeAll(c);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.keySet().toString();
    }
}

