/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.CompilerModeProvider;
import org.jetbrains.jet.OperationModeProvider;
import org.jetbrains.jet.asJava.JavaElementFinder;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.ClassPath;
import org.jetbrains.jet.cli.jvm.compiler.CliJetFilesProvider;
import org.jetbrains.jet.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.jet.cli.jvm.compiler.CliVirtualFileFinder;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CoreExternalAnnotationsManager;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.lang.parsing.JetParserDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JetFilesProvider;
import org.jetbrains.jet.lang.resolve.java.vfilefinder.VirtualFileFinder;
import org.jetbrains.jet.plugin.JetFileType;
import org.jetbrains.jet.utils.PathUtil;

public class JetCoreEnvironment {
    private final JavaCoreApplicationEnvironment applicationEnvironment;
    private final JavaCoreProjectEnvironment projectEnvironment;
    private final List<JetFile> sourceFiles = new ArrayList<JetFile>();
    private final ClassPath classPath = new ClassPath();
    private final CoreExternalAnnotationsManager annotationsManager;
    private final CompilerConfiguration configuration;

    public JetCoreEnvironment(Disposable parentDisposable, @NotNull CompilerConfiguration configuration) {
        this.configuration = configuration.copy();
        this.configuration.setReadOnly(true);
        this.applicationEnvironment = new JavaCoreApplicationEnvironment(parentDisposable);
        this.applicationEnvironment.registerFileType(PlainTextFileType.INSTANCE, "xml");
        this.applicationEnvironment.registerFileType(JetFileType.INSTANCE, "kt");
        this.applicationEnvironment.registerFileType(JetFileType.INSTANCE, "kts");
        this.applicationEnvironment.registerFileType(JetFileType.INSTANCE, "ktm");
        this.applicationEnvironment.registerFileType(JetFileType.INSTANCE, "ktscript");
        this.applicationEnvironment.registerFileType(JetFileType.INSTANCE, "jet");
        this.applicationEnvironment.registerParserDefinition(new JavaParserDefinition());
        this.applicationEnvironment.registerParserDefinition(new JetParserDefinition());
        this.applicationEnvironment.getApplication().registerService(OperationModeProvider.class, new CompilerModeProvider());
        this.projectEnvironment = new JavaCoreProjectEnvironment(parentDisposable, this.applicationEnvironment);
        MockProject project = this.projectEnvironment.getProject();
        project.registerService(JetScriptDefinitionProvider.class, new JetScriptDefinitionProvider());
        project.registerService(JetFilesProvider.class, new CliJetFilesProvider(this));
        project.registerService(CoreJavaFileManager.class, (CoreJavaFileManager)ServiceManager.getService(project, JavaFileManager.class));
        CliLightClassGenerationSupport cliLightClassGenerationSupport = new CliLightClassGenerationSupport();
        project.registerService(LightClassGenerationSupport.class, cliLightClassGenerationSupport);
        project.registerService(CliLightClassGenerationSupport.class, cliLightClassGenerationSupport);
        Extensions.getArea(project).getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new JavaElementFinder(project, cliLightClassGenerationSupport));
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
        this.annotationsManager = new CoreExternalAnnotationsManager(project.getComponent(PsiManager.class));
        project.registerService(ExternalAnnotationsManager.class, this.annotationsManager);
        for (Object path : configuration.getList(JVMConfigurationKeys.CLASSPATH_KEY)) {
            this.addToClasspath((File)path);
        }
        for (Object path : configuration.getList(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY)) {
            this.addExternalAnnotationsRoot((File)path);
        }
        for (Object path : configuration.getList(CommonConfigurationKeys.SOURCE_ROOTS_KEY)) {
            this.addSources((String)path);
        }
        JetScriptDefinitionProvider.getInstance(project).addScriptDefinitions(configuration.getList(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY));
        project.registerService(VirtualFileFinder.class, new CliVirtualFileFinder(this.classPath));
    }

    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public MockApplication getApplication() {
        return this.applicationEnvironment.getApplication();
    }

    @NotNull
    public Project getProject() {
        return this.projectEnvironment.getProject();
    }

    private void addExternalAnnotationsRoot(File path) {
        if (!path.exists()) {
            this.report(CompilerMessageSeverity.WARNING, "Annotations path entry points to a non-existent location: " + path);
            return;
        }
        this.annotationsManager.addExternalAnnotationsRoot(PathUtil.jarFileOrDirectoryToVirtualFile(path));
    }

    private void addSources(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.addSources(child);
                }
            }
        } else {
            PsiFile psiFile;
            VirtualFile fileByPath = this.applicationEnvironment.getLocalFileSystem().findFileByPath(file.getAbsolutePath());
            if (fileByPath != null && (psiFile = PsiManager.getInstance(this.getProject()).findFile(fileByPath)) instanceof JetFile) {
                this.sourceFiles.add((JetFile)psiFile);
            }
        }
    }

    private void addSources(String path) {
        if (path == null) {
            return;
        }
        VirtualFile vFile = this.applicationEnvironment.getLocalFileSystem().findFileByPath(path);
        if (vFile == null) {
            this.report(CompilerMessageSeverity.ERROR, "Source file or directory not found: " + path);
            return;
        }
        if (!vFile.isDirectory() && vFile.getFileType() != JetFileType.INSTANCE) {
            this.report(CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + path);
            return;
        }
        this.addSources(new File(path));
    }

    private void addToClasspath(File path) {
        if (path.isFile()) {
            VirtualFile jarFile = this.applicationEnvironment.getJarFileSystem().findFileByPath(path + "!/");
            if (jarFile == null) {
                this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a file that is not a JAR archive: " + path);
                return;
            }
            this.projectEnvironment.addJarToClassPath(path);
            this.classPath.add(jarFile);
        } else {
            VirtualFile root = this.applicationEnvironment.getLocalFileSystem().findFileByPath(path.getAbsolutePath());
            if (root == null) {
                this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a non-existent location: " + path);
                return;
            }
            this.projectEnvironment.addSourcesToClasspath(root);
            this.classPath.add(root);
        }
    }

    public List<JetFile> getSourceFiles() {
        return this.sourceFiles;
    }

    private void report(@NotNull CompilerMessageSeverity severity, @NotNull String message) {
        MessageCollector messageCollector = this.configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector == null) {
            throw new CompileEnvironmentException(message);
        }
        messageCollector.report(severity, message, CompilerMessageLocation.NO_LOCATION);
    }
}

