/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.MemberMap;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBufUtil;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializerExtension;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaSerializerExtension
extends SerializerExtension {
    private final MemberMap memberMap;

    public JavaSerializerExtension(@NotNull MemberMap memberMap) {
        this.memberMap = memberMap;
    }

    @Override
    public void serializeCallable(@NotNull CallableMemberDescriptor callable, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        this.saveSignature(callable, proto, nameTable);
        this.saveSrcClassName(callable, proto, nameTable);
    }

    private void saveSignature(@NotNull CallableMemberDescriptor callable, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable instanceof FunctionDescriptor) {
            Method method = this.memberMap.getMethodOfDescriptor((FunctionDescriptor)callable);
            if (method != null) {
                JavaProtoBufUtil.saveMethodSignature(proto, method, nameTable);
            }
        } else if (callable instanceof PropertyDescriptor) {
            String syntheticMethodName;
            boolean isStaticInOuter;
            String fieldName;
            Type fieldType;
            PropertyDescriptor property = (PropertyDescriptor)callable;
            PropertyGetterDescriptor getter = property.getGetter();
            PropertySetterDescriptor setter = property.getSetter();
            Method getterMethod = getter == null ? null : this.memberMap.getMethodOfDescriptor(getter);
            Method setterMethod = setter == null ? null : this.memberMap.getMethodOfDescriptor(setter);
            Pair<Type, String> field = this.memberMap.getFieldOfProperty(property);
            if (field != null) {
                fieldType = (Type)field.first;
                fieldName = (String)field.second;
                isStaticInOuter = this.memberMap.isStaticFieldInOuterClass(property);
                syntheticMethodName = null;
            } else {
                fieldType = null;
                fieldName = null;
                isStaticInOuter = false;
                syntheticMethodName = this.memberMap.getSyntheticMethodNameOfProperty(property);
            }
            JavaProtoBufUtil.savePropertySignature(proto, fieldType, fieldName, isStaticInOuter, syntheticMethodName, getterMethod, setterMethod, nameTable);
        }
    }

    private void saveSrcClassName(@NotNull CallableMemberDescriptor callable, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        Name name = this.memberMap.getSrcClassNameOfCallable(callable);
        if (name != null) {
            JavaProtoBufUtil.saveSrcClassName(proto, name, nameTable);
        }
    }
}

