/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;

public abstract class AbstractDescriptorFinder
implements DescriptorFinder {
    private final MemoizedFunctionToNullable<ClassId, ClassDescriptor> findClass;
    private final AnnotationDeserializer annotationDeserializer;

    public AbstractDescriptorFinder(final @NotNull StorageManager storageManager, @NotNull AnnotationDeserializer annotationDeserializer) {
        this.annotationDeserializer = annotationDeserializer;
        this.findClass = storageManager.createMemoizedFunctionWithNullableValues(new Function<ClassId, ClassDescriptor>(){

            @Override
            public ClassDescriptor fun(ClassId classId) {
                ClassOrNamespaceDescriptor owner;
                ClassData classData = AbstractDescriptorFinder.this.getClassData(classId);
                if (classData == null) {
                    return null;
                }
                ProtoBuf.Class classProto = classData.getClassProto();
                ClassOrNamespaceDescriptor classOrNamespaceDescriptor = owner = classId.isTopLevelClass() ? AbstractDescriptorFinder.this.findPackage(classId.getPackageFqName()) : AbstractDescriptorFinder.this.findClass(classId.getOuterClassId());
                assert (owner != null) : "No owner found for " + classId;
                AbstractDescriptorFinder _this = AbstractDescriptorFinder.this;
                DeserializedClassDescriptor classDescriptor = new DeserializedClassDescriptor(classId, storageManager, owner, classData.getNameResolver(), _this.annotationDeserializer, _this, classProto, null);
                AbstractDescriptorFinder.this.classDescriptorCreated(classDescriptor);
                return classDescriptor;
            }
        }, StorageManager.ReferenceKind.STRONG);
    }

    @Override
    @Nullable
    public ClassDescriptor findClass(@NotNull ClassId classId) {
        return this.findClass.fun(classId);
    }

    @Nullable
    protected abstract ClassData getClassData(@NotNull ClassId var1);

    protected void classDescriptorCreated(@NotNull ClassDescriptor classDescriptor) {
    }
}

