/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetCallableReferenceExpression
extends JetExpressionImpl {
    public JetCallableReferenceExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.findChildByType(JetNodeTypes.TYPE_REFERENCE);
    }

    @NotNull
    public JetSimpleNameExpression getCallableReference() {
        for (ASTNode node = this.getNode().findChildByType(JetTokens.COLONCOLON); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetSimpleNameExpression)) continue;
            return (JetSimpleNameExpression)psi;
        }
        throw new IllegalStateException("Callable reference simple name shouldn't be parsed to null");
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitCallableReferenceExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitCallableReferenceExpression(this, data);
    }
}

