/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TraceEntryFilter;
import org.jetbrains.jet.util.slicedmap.MutableSlicedMap;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.SlicedMapImpl;
import org.jetbrains.jet.util.slicedmap.SlicedMapKey;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class DelegatingBindingTrace
implements BindingTrace {
    private final MutableSlicedMap map = SlicedMapImpl.create();
    private final BindingContext parentContext;
    private final List<Diagnostic> diagnostics = Lists.newArrayList();
    private final String name;
    private final BindingContext bindingContext = new BindingContext(){

        @Override
        @NotNull
        public Collection<Diagnostic> getDiagnostics() {
            ArrayList<Diagnostic> mergedDiagnostics = new ArrayList<Diagnostic>(DelegatingBindingTrace.this.diagnostics);
            mergedDiagnostics.addAll(DelegatingBindingTrace.this.parentContext.getDiagnostics());
            return mergedDiagnostics;
        }

        @Override
        public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
            return DelegatingBindingTrace.this.get(slice, key);
        }

        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
            return DelegatingBindingTrace.this.getKeys(slice);
        }

        @Override
        @NotNull
        public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
            ImmutableMap<K, V> parentContents = DelegatingBindingTrace.this.parentContext.getSliceContents(slice);
            ImmutableMap<K, V> currentContents = DelegatingBindingTrace.this.map.getSliceContents(slice);
            return ImmutableMap.builder().putAll(parentContents).putAll(currentContents).build();
        }
    };

    public DelegatingBindingTrace(BindingContext parentContext, String debugName) {
        this.parentContext = parentContext;
        this.name = debugName;
    }

    public DelegatingBindingTrace(BindingContext parentContext, String debugName, @Nullable Object resolutionSubjectForMessage) {
        this(parentContext, AnalyzingUtils.formDebugNameForBindingTrace(debugName, resolutionSubjectForMessage));
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
        this.map.put(slice, key, value);
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        V value = this.map.get(slice, key);
        if (slice instanceof Slices.SetSlice) {
            assert (value != null);
            if (value.equals(true)) {
                return value;
            }
        } else if (value != null) {
            return value;
        }
        return this.parentContext.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> keys = this.map.getKeys(slice);
        Collection<K> fromParent = this.parentContext.getKeys(slice);
        if (keys.isEmpty()) {
            return fromParent;
        }
        if (fromParent.isEmpty()) {
            return keys;
        }
        ArrayList<K> result = Lists.newArrayList(keys);
        result.addAll(fromParent);
        return result;
    }

    public void addAllMyDataTo(@NotNull BindingTrace trace) {
        this.addAllMyDataTo(trace, null, true);
    }

    public void moveAllMyDataTo(@NotNull BindingTrace trace) {
        this.addAllMyDataTo(trace, null, true);
        this.clear();
    }

    public void addAllMyDataTo(@NotNull BindingTrace trace, @Nullable TraceEntryFilter filter, boolean commitDiagnostics) {
        for (Map.Entry entry : this.map) {
            SlicedMapKey slicedMapKey = (SlicedMapKey)entry.getKey();
            WritableSlice slice = slicedMapKey.getSlice();
            Object key = slicedMapKey.getKey();
            Object value = entry.getValue();
            if (filter != null && !filter.accept(slice, key)) continue;
            trace.record(slice, key, value);
        }
        if (!commitDiagnostics) {
            return;
        }
        for (Diagnostic diagnostic : this.diagnostics) {
            trace.report(diagnostic);
        }
    }

    public void clear() {
        this.map.clear();
        this.diagnostics.clear();
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        this.diagnostics.add(diagnostic);
    }

    public String toString() {
        return this.name;
    }
}

