/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraints;
import org.jetbrains.jet.lang.resolve.calls.inference.TypeConstraintsImpl;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.IntersectionTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class ConstraintsUtil {
    @NotNull
    public static Set<JetType> getValues(@Nullable TypeConstraints typeConstraints) {
        JetType superTypeOfAllLowerBounds;
        JetType exactBound;
        LinkedHashSet<JetType> values = Sets.newLinkedHashSet();
        if (typeConstraints == null || typeConstraints.isEmpty()) {
            return values;
        }
        TypeConstraints typeConstraintsWithoutErrorTypes = ConstraintsUtil.filterNotContainingErrorType(typeConstraints, values);
        Set<JetType> exactBounds = typeConstraintsWithoutErrorTypes.getExactBounds();
        if (exactBounds.size() == 1 && ConstraintsUtil.trySuggestion(exactBound = (JetType)exactBounds.iterator().next(), typeConstraints)) {
            return Collections.singleton(exactBound);
        }
        values.addAll(exactBounds);
        Pair<Collection<JetType>, Collection<JetType>> pair = TypeUtils.filterNumberTypes(typeConstraintsWithoutErrorTypes.getLowerBounds());
        Collection<JetType> generalLowerBounds = pair.getFirst();
        Collection<JetType> numberLowerBounds = pair.getSecond();
        JetType superTypeOfLowerBounds = ConstraintsUtil.commonSupertype(generalLowerBounds);
        if (ConstraintsUtil.trySuggestion(superTypeOfLowerBounds, typeConstraints)) {
            return Collections.singleton(superTypeOfLowerBounds);
        }
        ContainerUtil.addIfNotNull(superTypeOfLowerBounds, values);
        Set<JetType> upperBounds = typeConstraintsWithoutErrorTypes.getUpperBounds();
        for (JetType upperBound : upperBounds) {
            if (!ConstraintsUtil.trySuggestion(upperBound, typeConstraints)) continue;
            return Collections.singleton(upperBound);
        }
        values.addAll(typeConstraintsWithoutErrorTypes.getUpperBounds());
        JetType superTypeOfNumberLowerBounds = ConstraintsUtil.commonSupertypeForNumberTypes(numberLowerBounds);
        if (ConstraintsUtil.trySuggestion(superTypeOfNumberLowerBounds, typeConstraints)) {
            return Collections.singleton(superTypeOfNumberLowerBounds);
        }
        ContainerUtil.addIfNotNull(superTypeOfNumberLowerBounds, values);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && ConstraintsUtil.trySuggestion(superTypeOfAllLowerBounds = ConstraintsUtil.commonSupertype(Lists.newArrayList(superTypeOfLowerBounds, superTypeOfNumberLowerBounds)), typeConstraints)) {
            return Collections.singleton(superTypeOfAllLowerBounds);
        }
        return values;
    }

    @Nullable
    private static JetType commonSupertype(@NotNull Collection<JetType> lowerBounds) {
        JetType type;
        if (lowerBounds.isEmpty()) {
            return null;
        }
        if (lowerBounds.size() == 1 && (type = lowerBounds.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return ConstraintsUtil.commonSupertype(type.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(lowerBounds);
    }

    @Nullable
    private static JetType commonSupertypeForNumberTypes(@NotNull Collection<JetType> numberLowerBounds) {
        if (numberLowerBounds.isEmpty()) {
            return null;
        }
        return TypeUtils.commonSupertypeForNumberTypes(numberLowerBounds);
    }

    private static boolean trySuggestion(@Nullable JetType suggestion, @NotNull TypeConstraints typeConstraints) {
        if (suggestion == null) {
            return false;
        }
        if (!suggestion.getConstructor().isDenotable()) {
            return false;
        }
        if (typeConstraints.getExactBounds().size() > 1) {
            return false;
        }
        for (JetType exactBound : typeConstraints.getExactBounds()) {
            if (JetTypeChecker.INSTANCE.equalTypes(exactBound, suggestion)) continue;
            return false;
        }
        for (JetType lowerBound : typeConstraints.getLowerBounds()) {
            if (JetTypeChecker.INSTANCE.isSubtypeOf(lowerBound, suggestion)) continue;
            return false;
        }
        for (JetType upperBound : typeConstraints.getUpperBounds()) {
            if (JetTypeChecker.INSTANCE.isSubtypeOf(suggestion, upperBound)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static TypeConstraints filterNotContainingErrorType(@NotNull TypeConstraints typeConstraints, @NotNull Collection<JetType> values) {
        TypeConstraintsImpl typeConstraintsWithoutErrorType = new TypeConstraintsImpl(typeConstraints.getVarianceOfPosition());
        Collection<Pair<TypeConstraintsImpl.BoundKind, JetType>> allBounds = ((TypeConstraintsImpl)typeConstraints).getAllBounds();
        for (Pair<TypeConstraintsImpl.BoundKind, JetType> pair : allBounds) {
            TypeConstraintsImpl.BoundKind boundKind = pair.getFirst();
            JetType type = pair.getSecond();
            if (ErrorUtils.containsErrorType(type)) {
                values.add(type);
                continue;
            }
            if (type == null) continue;
            typeConstraintsWithoutErrorType.addBound(boundKind, type);
        }
        return typeConstraintsWithoutErrorType;
    }

    @Nullable
    public static JetType getValue(@Nullable TypeConstraints typeConstraints) {
        if (typeConstraints == null) {
            return null;
        }
        Set<JetType> values = ConstraintsUtil.getValues(typeConstraints);
        if (values.size() == 1) {
            return values.iterator().next();
        }
        return null;
    }

    @Nullable
    public static TypeParameterDescriptor getFirstConflictingParameter(@NotNull ConstraintSystem constraintSystem) {
        for (TypeParameterDescriptor typeParameter : constraintSystem.getTypeVariables()) {
            TypeConstraints constraints = constraintSystem.getTypeConstraints(typeParameter);
            if (ConstraintsUtil.getValues(constraints).size() <= 1) continue;
            return typeParameter;
        }
        return null;
    }

    @NotNull
    public static Collection<TypeSubstitutor> getSubstitutorsForConflictingParameters(@NotNull ConstraintSystem constraintSystem) {
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(constraintSystem);
        if (firstConflictingParameter == null) {
            return Collections.emptyList();
        }
        Set<JetType> conflictingTypes = ConstraintsUtil.getValues(constraintSystem.getTypeConstraints(firstConflictingParameter));
        ArrayList substitutionContexts = Lists.newArrayList();
        for (JetType type : conflictingTypes) {
            LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = Maps.newLinkedHashMap();
            linkedHashMap.put(firstConflictingParameter.getTypeConstructor(), new TypeProjection(type));
            substitutionContexts.add(linkedHashMap);
        }
        for (TypeParameterDescriptor typeParameter : constraintSystem.getTypeVariables()) {
            if (typeParameter == firstConflictingParameter) continue;
            JetType jetType = ConstraintsUtil.getSafeValue(constraintSystem, typeParameter);
            for (Map map : substitutionContexts) {
                TypeProjection typeProjection = new TypeProjection(jetType);
                map.put(typeParameter.getTypeConstructor(), typeProjection);
            }
        }
        ArrayList<TypeSubstitutor> typeSubstitutors = Lists.newArrayList();
        for (Map map : substitutionContexts) {
            typeSubstitutors.add(TypeSubstitutor.create(map));
        }
        return typeSubstitutors;
    }

    @NotNull
    public static JetType getSafeValue(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter) {
        TypeConstraints constraints = constraintSystem.getTypeConstraints(typeParameter);
        JetType type = ConstraintsUtil.getValue(constraints);
        if (type != null) {
            return type;
        }
        return typeParameter.getUpperBoundsAsType();
    }

    public static boolean checkUpperBoundIsSatisfied(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter, boolean substituteOtherTypeParametersInBound) {
        TypeConstraints typeConstraints = constraintSystem.getTypeConstraints(typeParameter);
        assert (typeConstraints != null);
        JetType type = ConstraintsUtil.getValue(typeConstraints);
        if (type == null) {
            return true;
        }
        for (JetType upperBound : typeParameter.getUpperBounds()) {
            if (!substituteOtherTypeParametersInBound && TypeUtils.dependsOnTypeParameters(upperBound, constraintSystem.getTypeVariables())) continue;
            JetType substitutedUpperBound = constraintSystem.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            assert (substitutedUpperBound != null) : "We wanted to substitute projections as a result for " + typeParameter;
            if (JetTypeChecker.INSTANCE.isSubtypeOf(type, substitutedUpperBound)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkBoundsAreSatisfied(@NotNull ConstraintSystem constraintSystem, boolean substituteOtherTypeParametersInBounds) {
        for (TypeParameterDescriptor typeVariable : constraintSystem.getTypeVariables()) {
            if (ConstraintsUtil.checkUpperBoundIsSatisfied(constraintSystem, typeVariable, substituteOtherTypeParametersInBounds)) continue;
            return false;
        }
        return true;
    }
}

