/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.model;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;

public class DataFlowInfoForArgumentsImpl
implements MutableDataFlowInfoForArguments {
    private final Call call;
    private final Map<ValueArgument, DataFlowInfo> infoMap = Maps.newHashMap();
    private final Map<ValueArgument, ValueArgument> nextArgument = Maps.newHashMap();
    private DataFlowInfo initialInfo;
    private DataFlowInfo resultInfo;

    public DataFlowInfoForArgumentsImpl(@NotNull Call call) {
        this.call = call;
        this.initNextArgMap(call.getValueArguments());
    }

    private void initNextArgMap(@NotNull List<? extends ValueArgument> valueArguments) {
        Iterator<? extends ValueArgument> iterator = valueArguments.iterator();
        ValueArgument prev = null;
        while (iterator.hasNext()) {
            ValueArgument argument = iterator.next();
            if (prev != null) {
                this.nextArgument.put(prev, argument);
            }
            prev = argument;
        }
    }

    @Override
    public void setInitialDataFlowInfo(@NotNull DataFlowInfo dataFlowInfo) {
        this.initialInfo = dataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
        DataFlowInfo infoForArgument = this.infoMap.get(valueArgument);
        if (infoForArgument == null) {
            return this.initialInfo;
        }
        return this.initialInfo.and(infoForArgument);
    }

    @Override
    public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
        ValueArgument next = this.nextArgument.get(valueArgument);
        if (next != null) {
            this.infoMap.put(next, dataFlowInfo);
            return;
        }
        this.resultInfo = dataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo getResultInfo() {
        if (this.resultInfo == null) {
            return this.initialInfo;
        }
        assert (this.initialInfo != null) : "Initial data flow info was not set for call: " + this.call;
        return this.initialInfo.and(this.resultInfo);
    }
}

