/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;

public class ResolutionTask<D extends CallableDescriptor, F extends D>
extends CallResolutionContext<ResolutionTask<D, F>> {
    private final Collection<ResolutionCandidate<D>> candidates;
    private final Set<ResolvedCallWithTrace<F>> resolvedCalls = Sets.newLinkedHashSet();
    private DescriptorCheckStrategy checkingStrategy;
    public final JetReferenceExpression reference;
    public final TracingStrategy tracing;

    public ResolutionTask(@NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull JetReferenceExpression reference, @NotNull TracingStrategy tracing, BindingTrace trace, JetScope scope, Call call, JetType expectedType, DataFlowInfo dataFlowInfo, ContextDependency contextDependency, CheckValueArgumentsMode checkArguments, ExpressionPosition expressionPosition, ResolutionResultsCache resolutionResultsCache, @NotNull LabelResolver labelResolver, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        super(trace, scope, call, expectedType, dataFlowInfo, contextDependency, checkArguments, expressionPosition, resolutionResultsCache, labelResolver, dataFlowInfoForArguments);
        this.candidates = candidates;
        this.reference = reference;
        this.tracing = tracing;
    }

    public ResolutionTask(@NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull JetReferenceExpression reference, @NotNull BasicCallResolutionContext context, @Nullable TracingStrategy tracing) {
        this(candidates, reference, tracing != null ? tracing : TracingStrategyImpl.create(reference, context.call), context.trace, context.scope, context.call, context.expectedType, context.dataFlowInfo, context.contextDependency, context.checkArguments, context.expressionPosition, context.resolutionResultsCache, context.labelResolver, context.dataFlowInfoForArguments);
    }

    public ResolutionTask(@NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull JetReferenceExpression reference, @NotNull BasicCallResolutionContext context) {
        this(candidates, reference, context, null);
    }

    @NotNull
    public Collection<ResolutionCandidate<D>> getCandidates() {
        return this.candidates;
    }

    @NotNull
    public Set<ResolvedCallWithTrace<F>> getResolvedCalls() {
        return this.resolvedCalls;
    }

    public void setCheckingStrategy(DescriptorCheckStrategy strategy) {
        this.checkingStrategy = strategy;
    }

    public boolean performAdvancedChecks(D descriptor, BindingTrace trace, TracingStrategy tracing) {
        return this.checkingStrategy == null || this.checkingStrategy.performAdvancedChecks(descriptor, trace, tracing);
    }

    @Override
    protected ResolutionTask<D, F> create(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, @NotNull ExpressionPosition expressionPosition, @NotNull ContextDependency contextDependency, @NotNull ResolutionResultsCache resolutionResultsCache, @NotNull LabelResolver labelResolver) {
        ResolutionTask<D, F> newTask = new ResolutionTask<D, F>(this.candidates, this.reference, this.tracing, trace, scope, this.call, expectedType, dataFlowInfo, contextDependency, this.checkArguments, expressionPosition, resolutionResultsCache, labelResolver, this.dataFlowInfoForArguments);
        newTask.setCheckingStrategy(this.checkingStrategy);
        return newTask;
    }

    @Override
    protected ResolutionTask<D, F> self() {
        return this;
    }

    public ResolutionTask<D, F> replaceCall(@NotNull Call newCall) {
        return new ResolutionTask<D, F>(this.candidates, this.reference, this.tracing, this.trace, this.scope, newCall, this.expectedType, this.dataFlowInfo, this.contextDependency, this.checkArguments, this.expressionPosition, this.resolutionResultsCache, this.labelResolver, this.dataFlowInfoForArguments);
    }

    public String toString() {
        return this.candidates.toString();
    }

    public static interface DescriptorCheckStrategy {
        public <D extends CallableDescriptor> boolean performAdvancedChecks(D var1, BindingTrace var2, TracingStrategy var3);
    }
}

