/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public abstract class ErrorValue
implements CompileTimeConstant<Void> {
    @Override
    @Deprecated
    public Void getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data) {
        return visitor.visitErrorValue(this, data);
    }

    public static ErrorValue create(@NotNull String message) {
        return new ErrorValueWithMessage(message);
    }

    public static ErrorValue create(@NotNull Diagnostic diagnostic) {
        return new ErrorValueWithDiagnostic(diagnostic);
    }

    public static class ErrorValueWithDiagnostic
    extends ErrorValue {
        private final Diagnostic diagnostic;

        public ErrorValueWithDiagnostic(@NotNull Diagnostic diagnostic) {
            this.diagnostic = diagnostic;
        }

        public Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Override
        @NotNull
        public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return DefaultErrorMessages.RENDERER.render(this.diagnostic);
        }
    }

    public static class ErrorValueWithMessage
    extends ErrorValue {
        private final String message;

        public ErrorValueWithMessage(@NotNull String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
            return ErrorUtils.createErrorType(this.message);
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

