/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JavaPsiFacadeKotlinHacks;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.jetAsJava.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetFileType;

public class PsiClassFinderImpl
implements PsiClassFinder {
    @NotNull
    private Project project;
    private GlobalSearchScope javaSearchScope;
    private JavaPsiFacadeKotlinHacks javaFacade;

    public void setProject(@NotNull Project project) {
        this.project = project;
    }

    @PostConstruct
    public void initialize() {
        this.javaSearchScope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope(this.project)){

            @Override
            public boolean contains(VirtualFile file) {
                return this.myBaseScope.contains(file) && file.getFileType() != JetFileType.INSTANCE;
            }

            @Override
            public int compare(VirtualFile file1, VirtualFile file2) {
                int compare = super.compare(file1, file2);
                if (compare == 0) {
                    return Comparing.compare(file1.getPath(), file2.getPath());
                }
                return compare;
            }
        };
        this.javaFacade = new JavaPsiFacadeKotlinHacks(this.project);
    }

    @Override
    @Nullable
    public PsiClass findPsiClass(@NotNull FqName qualifiedName) {
        PsiClass original = this.javaFacade.findClass(qualifiedName.asString(), this.javaSearchScope);
        if (original != null) {
            FqName actualQualifiedName;
            String classQualifiedName = original.getQualifiedName();
            FqName fqName = actualQualifiedName = classQualifiedName != null ? new FqName(classQualifiedName) : null;
            if (!qualifiedName.equals(actualQualifiedName)) {
                throw new IllegalStateException("requested " + qualifiedName + ", got " + actualQualifiedName);
            }
        }
        if (original instanceof JetJavaMirrorMarker) {
            throw new IllegalStateException("JetJavaMirrorMaker is not possible in resolve.java, resolving: " + qualifiedName);
        }
        return original;
    }

    @Override
    @Nullable
    public PsiPackage findPsiPackage(@NotNull FqName qualifiedName) {
        return this.javaFacade.findPackage(qualifiedName.asString());
    }
}

