/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.mapping;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMapBuilder;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public class KotlinToJavaTypesMap
extends JavaToKotlinClassMapBuilder {
    private static KotlinToJavaTypesMap instance = null;
    private final Map<FqName, Type> asmTypes = new HashMap<FqName, Type>();
    private final Map<FqName, Type> asmNullableTypes = new HashMap<FqName, Type>();

    @NotNull
    public static KotlinToJavaTypesMap getInstance() {
        if (instance == null) {
            instance = new KotlinToJavaTypesMap();
        }
        return instance;
    }

    private KotlinToJavaTypesMap() {
        this.init();
        this.initPrimitives();
    }

    private void initPrimitives() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            FqName className = jvmPrimitiveType.getPrimitiveType().getClassName();
            this.register(className, jvmPrimitiveType.getAsmType());
            this.registerNullable(className, jvmPrimitiveType.getWrapper().getAsmType());
        }
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.register(primitiveType.getArrayClassName(), jvmPrimitiveType.getAsmArrayType());
        }
    }

    @Nullable
    public Type getJavaAnalog(@NotNull JetType jetType) {
        Type nullableType;
        ClassifierDescriptor classifier = jetType.getConstructor().getDeclarationDescriptor();
        assert (classifier != null);
        FqNameUnsafe className = DescriptorUtils.getFQName(classifier);
        if (!className.isSafe()) {
            return null;
        }
        FqName fqName = className.toSafe();
        if (jetType.isNullable() && (nullableType = this.asmNullableTypes.get(fqName)) != null) {
            return nullableType;
        }
        return this.asmTypes.get(fqName);
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.KOTLIN_TO_JAVA) {
            this.register(kotlinDescriptor, AsmTypeConstants.getType(javaClass));
        }
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.KOTLIN_TO_JAVA) {
            this.register(javaClass, kotlinDescriptor);
            this.register(javaClass, kotlinMutableDescriptor);
        }
    }

    private void register(@NotNull ClassDescriptor kotlinDescriptor, @NotNull Type javaType) {
        FqNameUnsafe fqName = DescriptorUtils.getFQName(kotlinDescriptor);
        assert (fqName.isSafe());
        this.register(fqName.toSafe(), javaType);
    }

    private void register(@NotNull FqName fqName, @NotNull Type type) {
        this.asmTypes.put(fqName, type);
    }

    private void registerNullable(@NotNull FqName fqName, @NotNull Type nullableType) {
        this.asmNullableTypes.put(fqName, nullableType);
    }
}

