/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.ClassReader;
import org.jetbrains.asm4.ClassVisitor;
import org.jetbrains.asm4.FieldVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBufUtil;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationArgumentResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.vfilefinder.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.lazy.storage.LockBasedStorageManager;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ErrorUtils;

public class AnnotationDescriptorDeserializer
implements AnnotationDeserializer {
    private static final Logger LOG = Logger.getInstance(AnnotationDescriptorDeserializer.class);
    private JavaClassResolver javaClassResolver;
    private VirtualFileFinder virtualFileFinder;
    private final LockBasedStorageManager storageManager = new LockBasedStorageManager();
    private final MemoizedFunctionToNotNull<VirtualFile, Map<MemberSignature, List<AnnotationDescriptor>>> memberAnnotations = this.storageManager.createMemoizedFunction(new MemoizedFunctionToNotNull<VirtualFile, Map<MemberSignature, List<AnnotationDescriptor>>>(){

        @Override
        @NotNull
        public Map<MemberSignature, List<AnnotationDescriptor>> fun(@NotNull VirtualFile file) {
            try {
                return AnnotationDescriptorDeserializer.this.loadMemberAnnotationsFromFile(file);
            }
            catch (IOException e) {
                LOG.error("Error loading member annotations from file: " + file, e);
                return Collections.emptyMap();
            }
        }
    }, StorageManager.ReferenceKind.STRONG);

    public void setVirtualFileFinder(VirtualFileFinder virtualFileFinder) {
        this.virtualFileFinder = virtualFileFinder;
    }

    public void setJavaClassResolver(JavaClassResolver javaClassResolver) {
        this.javaClassResolver = javaClassResolver;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ClassDescriptor descriptor, @NotNull ProtoBuf.Class classProto) {
        VirtualFile virtualFile = this.findVirtualFileByClass(descriptor);
        if (virtualFile == null) {
            LOG.error("Virtual file for loading class annotations is not found: " + descriptor);
            return Collections.emptyList();
        }
        try {
            return this.loadClassAnnotationsFromFile(virtualFile);
        }
        catch (IOException e) {
            LOG.error("Error loading member annotations from file: " + virtualFile, e);
            return Collections.emptyList();
        }
    }

    @Nullable
    private VirtualFile findVirtualFileByDescriptor(@NotNull ClassOrNamespaceDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            return this.findVirtualFileByClass((ClassDescriptor)descriptor);
        }
        if (descriptor instanceof NamespaceDescriptor) {
            return this.findVirtualFileByPackage((NamespaceDescriptor)descriptor);
        }
        throw new IllegalStateException("Unrecognized descriptor: " + descriptor);
    }

    @Nullable
    private VirtualFile findVirtualFileByClass(@NotNull ClassDescriptor descriptor) {
        return this.virtualFileFinder.find(DeserializedResolverUtils.kotlinFqNameToJavaFqName(DeserializedResolverUtils.naiveKotlinFqName(descriptor)));
    }

    @Nullable
    private VirtualFile findVirtualFileByPackage(@NotNull NamespaceDescriptor descriptor) {
        return this.virtualFileFinder.find(PackageClassUtils.getPackageClassFqName(DescriptorUtils.getFQName(descriptor).toSafe()));
    }

    @NotNull
    private List<AnnotationDescriptor> loadClassAnnotationsFromFile(@NotNull VirtualFile virtualFile) throws IOException {
        final ArrayList<AnnotationDescriptor> result = new ArrayList<AnnotationDescriptor>();
        new ClassReader(virtualFile.getInputStream()).accept(new ClassVisitor(262144){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return AnnotationDescriptorDeserializer.this.resolveAnnotation(desc, result);
            }
        }, 7);
        return result;
    }

    private static boolean ignoreAnnotation(@NotNull String desc) {
        return desc.equals(JvmAnnotationNames.KOTLIN_CLASS.getDescriptor()) || desc.equals(JvmAnnotationNames.KOTLIN_PACKAGE.getDescriptor()) || desc.startsWith("Ljet/runtime/typeinfo/");
    }

    @NotNull
    private static FqName convertJvmDescriptorToFqName(@NotNull String desc) {
        assert (desc.startsWith("L") && desc.endsWith(";")) : "Not a JVM descriptor: " + desc;
        String fqName = desc.substring(1, desc.length() - 1).replace('$', '.').replace('/', '.');
        return new FqName(fqName);
    }

    @Nullable
    private AnnotationVisitor resolveAnnotation(@NotNull String desc, final @NotNull List<AnnotationDescriptor> result) {
        if (AnnotationDescriptorDeserializer.ignoreAnnotation(desc)) {
            return null;
        }
        FqName annotationFqName = AnnotationDescriptorDeserializer.convertJvmDescriptorToFqName(desc);
        final ClassDescriptor annotationClass = this.resolveAnnotationClass(annotationFqName);
        final AnnotationDescriptor annotation = new AnnotationDescriptor();
        annotation.setAnnotationType(annotationClass.getDefaultType());
        return new AnnotationVisitor(262144){

            @Override
            public void visit(String name, Object value) {
                ErrorValue argument = JavaAnnotationArgumentResolver.resolveCompileTimeConstantValue(value, null);
                this.setArgumentValueByName(name, argument != null ? argument : ErrorValue.create("Unsupported annotation argument: " + name));
            }

            @Override
            public void visitEnum(String name, String desc, String value) {
                FqName fqName = AnnotationDescriptorDeserializer.convertJvmDescriptorToFqName(desc);
                this.setArgumentValueByName(name, this.enumEntryValue(fqName, Name.identifier(value)));
            }

            @NotNull
            private CompileTimeConstant<?> enumEntryValue(@NotNull FqName enumFqName, @NotNull Name name) {
                VariableDescriptor property;
                Collection<VariableDescriptor> properties;
                ClassDescriptor classObject;
                ClassDescriptor enumClass = AnnotationDescriptorDeserializer.this.javaClassResolver.resolveClass(enumFqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
                if (enumClass != null && enumClass.getKind() == ClassKind.ENUM_CLASS && (classObject = enumClass.getClassObjectDescriptor()) != null && (properties = classObject.getDefaultType().getMemberScope().getProperties(name)).size() == 1 && (property = properties.iterator().next()) instanceof PropertyDescriptor) {
                    return new EnumValue((PropertyDescriptor)property);
                }
                return ErrorValue.create("Unresolved enum entry: " + enumFqName + "." + name);
            }

            @Override
            public void visitEnd() {
                result.add(annotation);
            }

            private void setArgumentValueByName(@NotNull String name, @NotNull CompileTimeConstant<?> argumentValue) {
                ValueParameterDescriptor parameter = DescriptorResolverUtils.getAnnotationParameterByName(Name.identifier(name), annotationClass);
                if (parameter != null) {
                    annotation.setValueArgument(parameter, argumentValue);
                }
            }
        };
    }

    @NotNull
    private ClassDescriptor resolveAnnotationClass(@NotNull FqName fqName) {
        ClassDescriptor annotationClass = this.javaClassResolver.resolveClass(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        return annotationClass != null ? annotationClass : ErrorUtils.getErrorClass();
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadCallableAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        List<AnnotationDescriptor> annotations;
        MemberSignature signature = AnnotationDescriptorDeserializer.getCallableSignature(proto, nameResolver, kind);
        if (signature == null) {
            return Collections.emptyList();
        }
        VirtualFile file = this.getVirtualFileWithMemberAnnotations(container, proto, nameResolver);
        if (file == null) {
            LOG.error("Virtual file for loading member annotations is not found: " + container);
        }
        return (annotations = this.memberAnnotations.fun(file).get(signature)) == null ? Collections.emptyList() : annotations;
    }

    @Nullable
    private VirtualFile getVirtualFileWithMemberAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (container instanceof NamespaceDescriptor) {
            VirtualFile srcFile;
            VirtualFile facadeFile;
            Name name = JavaProtoBufUtil.loadSrcClassName(proto, nameResolver);
            if (name != null && (facadeFile = this.findVirtualFileByPackage((NamespaceDescriptor)container)) != null && (srcFile = facadeFile.getParent().findChild(name + ".class")) != null) {
                return srcFile;
            }
            return null;
        }
        if (container instanceof ClassDescriptor && ((ClassDescriptor)container).getKind() == ClassKind.CLASS_OBJECT && JavaProtoBufUtil.isStaticFieldInOuter(proto)) {
            return this.findVirtualFileByDescriptor((ClassOrNamespaceDescriptor)container.getContainingDeclaration());
        }
        return this.findVirtualFileByDescriptor(container);
    }

    @Nullable
    private static MemberSignature getCallableSignature(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        switch (kind) {
            case FUNCTION: {
                return MemberSignature.fromMethod(JavaProtoBufUtil.loadMethodSignature(proto, nameResolver));
            }
            case PROPERTY_GETTER: {
                return MemberSignature.fromMethod(JavaProtoBufUtil.loadPropertyGetterSignature(proto, nameResolver));
            }
            case PROPERTY_SETTER: {
                return MemberSignature.fromMethod(JavaProtoBufUtil.loadPropertySetterSignature(proto, nameResolver));
            }
            case PROPERTY: {
                JavaProtoBufUtil.PropertyData data = JavaProtoBufUtil.loadPropertyData(proto, nameResolver);
                return data == null ? null : MemberSignature.fromPropertyData(data.getFieldType(), data.getFieldName(), data.getSyntheticMethodName());
            }
        }
        return null;
    }

    @NotNull
    private Map<MemberSignature, List<AnnotationDescriptor>> loadMemberAnnotationsFromFile(@NotNull VirtualFile file) throws IOException {
        final HashMap<MemberSignature, List<AnnotationDescriptor>> memberAnnotations = new HashMap<MemberSignature, List<AnnotationDescriptor>>();
        new ClassReader(file.getInputStream()).accept(new ClassVisitor(262144){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final MemberSignature methodSignature = MemberSignature.fromMethodNameAndDesc(name, desc);
                final ArrayList result = new ArrayList();
                return new MethodVisitor(262144){

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return AnnotationDescriptorDeserializer.this.resolveAnnotation(desc, result);
                    }

                    @Override
                    public void visitEnd() {
                        if (!result.isEmpty()) {
                            memberAnnotations.put(methodSignature, result);
                        }
                    }
                };
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                final MemberSignature fieldSignature = MemberSignature.fromFieldNameAndDesc(name, desc);
                final ArrayList result = new ArrayList();
                return new FieldVisitor(262144){

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return AnnotationDescriptorDeserializer.this.resolveAnnotation(desc, result);
                    }

                    @Override
                    public void visitEnd() {
                        if (!result.isEmpty()) {
                            memberAnnotations.put(fieldSignature, result);
                        }
                    }
                };
            }
        }, 7);
        return memberAnnotations;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ProtoBuf.Callable.ValueParameter parameterProto) {
        throw new UnsupportedOperationException();
    }

    private static final class MemberSignature {
        private final String signature;

        private MemberSignature(@NotNull String signature) {
            this.signature = signature;
        }

        @Nullable
        public static MemberSignature fromPropertyData(@Nullable Type fieldType, @Nullable String fieldName, @Nullable String syntheticMethodName) {
            if (fieldName != null && fieldType != null) {
                return MemberSignature.fromFieldNameAndDesc(fieldName, fieldType.getDescriptor());
            }
            if (syntheticMethodName != null) {
                return MemberSignature.fromMethodNameAndDesc(syntheticMethodName, "()V");
            }
            return null;
        }

        @Nullable
        public static MemberSignature fromMethod(@Nullable Method method) {
            return method == null ? null : MemberSignature.fromMethodNameAndDesc(method.getName(), method.getDescriptor());
        }

        @NotNull
        public static MemberSignature fromMethodNameAndDesc(@NotNull String name, @NotNull String desc) {
            return new MemberSignature(name + desc);
        }

        @NotNull
        public static MemberSignature fromFieldNameAndDesc(@NotNull String name, @NotNull String desc) {
            return new MemberSignature(name + "#" + desc);
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MemberSignature && this.signature.equals(((MemberSignature)o).signature);
        }

        public String toString() {
            return this.signature;
        }
    }
}

