/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinder;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.java.resolver.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaNamespaceResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSupertypeResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeParameterResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PostponedTasks;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassNonStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.vfilefinder.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaClassResolver {
    private static final Logger LOG = Logger.getInstance(JavaClassResolver.class);
    @NotNull
    private final Map<FqNameUnsafe, ClassDescriptor> classDescriptorCache = new HashMap<FqNameUnsafe, ClassDescriptor>();
    @NotNull
    private final Set<FqNameUnsafe> unresolvedCache = new HashSet<FqNameUnsafe>();
    private JavaResolverCache cache;
    private JavaTypeParameterResolver typeParameterResolver;
    private JavaMemberResolver memberResolver;
    private JavaAnnotationResolver annotationResolver;
    private JavaClassFinder javaClassFinder;
    private JavaNamespaceResolver namespaceResolver;
    private JavaSupertypeResolver supertypesResolver;
    private JavaFunctionResolver functionResolver;
    private DeserializedDescriptorResolver deserializedDescriptorResolver;
    private VirtualFileFinder virtualFileFinder;

    public void setVirtualFileFinder(VirtualFileFinder virtualFileFinder) {
        this.virtualFileFinder = virtualFileFinder;
    }

    public void setCache(JavaResolverCache cache) {
        this.cache = cache;
    }

    public void setDeserializedDescriptorResolver(DeserializedDescriptorResolver deserializedDescriptorResolver) {
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }

    public void setTypeParameterResolver(JavaTypeParameterResolver typeParameterResolver) {
        this.typeParameterResolver = typeParameterResolver;
    }

    public void setMemberResolver(JavaMemberResolver memberResolver) {
        this.memberResolver = memberResolver;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setJavaClassFinder(JavaClassFinder javaClassFinder) {
        this.javaClassFinder = javaClassFinder;
    }

    public void setNamespaceResolver(JavaNamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setSupertypesResolver(JavaSupertypeResolver supertypesResolver) {
        this.supertypesResolver = supertypesResolver;
    }

    public void setFunctionResolver(JavaFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule) {
        PostponedTasks postponedTasks = new PostponedTasks();
        ClassDescriptor classDescriptor = this.resolveClass(qualifiedName, searchRule, postponedTasks);
        postponedTasks.performTasks();
        return classDescriptor;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule, @NotNull PostponedTasks tasks) {
        ClassDescriptor kotlinClassDescriptor;
        if (JavaClassResolver.isTraitImplementation(qualifiedName)) {
            return null;
        }
        ClassDescriptor builtinClassDescriptor = JavaClassResolver.getKotlinBuiltinClassDescriptor(qualifiedName);
        if (builtinClassDescriptor != null) {
            return builtinClassDescriptor;
        }
        if (searchRule == DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES && (kotlinClassDescriptor = this.cache.getClassResolvedFromSource(qualifiedName)) != null) {
            return kotlinClassDescriptor;
        }
        FqNameUnsafe fqName = JavaClassResolver.javaClassToKotlinFqName(qualifiedName);
        ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(fqName);
        if (cachedDescriptor != null) {
            return cachedDescriptor;
        }
        if (this.unresolvedCache.contains(fqName)) {
            return null;
        }
        return this.doResolveClass(qualifiedName, tasks);
    }

    @Nullable
    private static ClassDescriptor getKotlinBuiltinClassDescriptor(@NotNull FqName qualifiedName) {
        if (!qualifiedName.firstSegmentIs(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME)) {
            return null;
        }
        List<Name> segments = qualifiedName.pathSegments();
        if (segments.size() < 2) {
            return null;
        }
        JetScope scope = KotlinBuiltIns.getInstance().getBuiltInsScope();
        int size = segments.size();
        for (int i = 1; i < size; ++i) {
            ClassifierDescriptor classifier = scope.getClassifier(segments.get(i));
            if (classifier == null) {
                return null;
            }
            assert (classifier instanceof ClassDescriptor) : "Unexpected classifier in built-ins: " + classifier;
            scope = ((ClassDescriptor)classifier).getUnsubstitutedInnerClassesScope();
        }
        return (ClassDescriptor)scope.getContainingDeclaration();
    }

    private ClassDescriptor doResolveClass(@NotNull FqName qualifiedName, @NotNull PostponedTasks tasks) {
        JavaClass javaClass;
        VirtualFile file = this.virtualFileFinder.find(qualifiedName);
        if (file != null) {
            boolean isInnerClass = file.getName().contains("$");
            ClassOrNamespaceDescriptor containingDeclaration = this.resolveParentDescriptor(qualifiedName, isInnerClass);
            ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(JavaClassResolver.javaClassToKotlinFqName(qualifiedName));
            if (cachedDescriptor != null) {
                return cachedDescriptor;
            }
            assert (!this.unresolvedCache.contains(qualifiedName.toUnsafe())) : "We can resolve the class, so it can't be 'unresolved' during parent resolution";
            ClassId id = ClassId.fromFqNameAndContainingDeclaration(qualifiedName.toUnsafe(), containingDeclaration);
            ClassDescriptor deserializedDescriptor = this.deserializedDescriptorResolver.resolveClass(id, file);
            if (deserializedDescriptor != null) {
                this.cache(JavaClassResolver.javaClassToKotlinFqName(qualifiedName), deserializedDescriptor);
                return deserializedDescriptor;
            }
        }
        if ((javaClass = this.javaClassFinder.findClass(qualifiedName)) == null) {
            this.cacheNegativeValue(JavaClassResolver.javaClassToKotlinFqName(qualifiedName));
            return null;
        }
        if (KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.equals(qualifiedName.parent()) && javaClass.findAnnotation(JvmAnnotationNames.ASSERT_INVISIBLE_IN_RESOLVER.getFqName()) != null) {
            if (ApplicationManager.getApplication().isInternal()) {
                LOG.error("classpath is configured incorrectly: class " + qualifiedName + " from runtime must not be loaded by compiler");
            }
            return null;
        }
        ClassDescriptor alreadyResolved = this.cache.getClass(javaClass);
        if (alreadyResolved != null) {
            return alreadyResolved;
        }
        ClassOrNamespaceDescriptor containingDeclaration = this.resolveParentDescriptor(qualifiedName, javaClass.getOuterClass() != null);
        ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(JavaClassResolver.javaClassToKotlinFqName(qualifiedName));
        if (cachedDescriptor != null) {
            return cachedDescriptor;
        }
        assert (!this.unresolvedCache.contains(qualifiedName.toUnsafe())) : "We can resolve the class, so it can't be 'unresolved' during parent resolution";
        this.checkFqNamesAreConsistent(javaClass, qualifiedName);
        assert (javaClass.getOriginKind() != JavaClass.OriginKind.KOTLIN_LIGHT_CLASS) : "Trying to resolve a light class as a regular PsiClass: " + javaClass.getFqName();
        return this.doCreateClassDescriptor(qualifiedName, javaClass, tasks, containingDeclaration);
    }

    private void cacheNegativeValue(@NotNull FqNameUnsafe fqNameUnsafe) {
        if (this.unresolvedCache.contains(fqNameUnsafe) || this.classDescriptorCache.containsKey(fqNameUnsafe)) {
            throw new IllegalStateException("rewrite at " + fqNameUnsafe);
        }
        this.unresolvedCache.add(fqNameUnsafe);
    }

    private static boolean isTraitImplementation(@NotNull FqName qualifiedName) {
        return qualifiedName.asString().endsWith("$$TImpl");
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode doCreateClassDescriptor(@NotNull FqName fqName, @NotNull JavaClass javaClass, @NotNull PostponedTasks taskList, @NotNull ClassOrNamespaceDescriptor containingDeclaration) {
        ClassDescriptorFromJvmBytecode classDescriptor = new ClassDescriptorFromJvmBytecode(containingDeclaration, JavaClassResolver.determineClassKind(javaClass), JavaClassResolver.isInnerClass(javaClass));
        this.cache(JavaClassResolver.javaClassToKotlinFqName(fqName), classDescriptor);
        classDescriptor.setName(javaClass.getName());
        JavaTypeParameterResolver.Initializer typeParameterInitializer = this.typeParameterResolver.resolveTypeParameters(classDescriptor, javaClass);
        classDescriptor.setTypeParameterDescriptors(typeParameterInitializer.getDescriptors());
        ArrayList<JetType> supertypes = new ArrayList<JetType>();
        classDescriptor.setSupertypes(supertypes);
        classDescriptor.setVisibility(javaClass.getVisibility());
        classDescriptor.setModality(JavaClassResolver.determineClassModality(javaClass));
        classDescriptor.createTypeConstructor();
        JavaClassNonStaticMembersScope scope = new JavaClassNonStaticMembersScope(classDescriptor, javaClass, false, this.memberResolver);
        classDescriptor.setScopeForMemberLookup(scope);
        classDescriptor.setScopeForConstructorResolve(scope);
        typeParameterInitializer.initialize();
        List<TypeParameterDescriptor> classTypeParameters = classDescriptor.getTypeConstructor().getParameters();
        supertypes.addAll(this.supertypesResolver.getSupertypes(classDescriptor, javaClass, classTypeParameters));
        if (javaClass.isEnum()) {
            ClassDescriptorFromJvmBytecode classObjectDescriptor = this.createClassObjectDescriptorForEnum(classDescriptor, javaClass);
            this.cache(JavaClassResolver.getFqNameForClassObject(javaClass), classObjectDescriptor);
            classDescriptor.getBuilder().setClassObjectDescriptor(classObjectDescriptor);
        }
        classDescriptor.setAnnotations(this.annotationResolver.resolveAnnotations(javaClass, taskList));
        this.cache.recordClass(javaClass, classDescriptor);
        JavaMethod samInterfaceMethod = SingleAbstractMethodUtils.getSamInterfaceMethod(javaClass);
        if (samInterfaceMethod != null) {
            SimpleFunctionDescriptor abstractMethod = this.resolveFunctionOfSamInterface(samInterfaceMethod, classDescriptor);
            classDescriptor.setFunctionTypeForSamInterface(SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(abstractMethod));
        }
        return classDescriptor;
    }

    @NotNull
    private static ClassKind determineClassKind(@NotNull JavaClass klass) {
        if (klass.isInterface()) {
            return klass.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : ClassKind.TRAIT;
        }
        return klass.isEnum() ? ClassKind.ENUM_CLASS : ClassKind.CLASS;
    }

    @NotNull
    private static Modality determineClassModality(@NotNull JavaClass klass) {
        return klass.isAnnotationType() ? Modality.FINAL : Modality.convertFromFlags(klass.isAbstract() || klass.isInterface(), !klass.isFinal());
    }

    @NotNull
    private static FqNameUnsafe getFqNameForClassObject(@NotNull JavaClass javaClass) {
        FqName fqName = javaClass.getFqName();
        assert (fqName != null) : "Reading java class with no qualified name";
        return fqName.toUnsafe().child(DescriptorUtils.getClassObjectName(javaClass.getName()));
    }

    @NotNull
    private SimpleFunctionDescriptor resolveFunctionOfSamInterface(@NotNull JavaMethod samInterfaceMethod, @NotNull ClassDescriptorFromJvmBytecode samInterface) {
        JavaClass methodContainer = samInterfaceMethod.getContainingClass();
        FqName containerFqName = methodContainer.getFqName();
        assert (containerFqName != null) : "qualified name is null for " + methodContainer;
        if (DescriptorUtils.getFQName(samInterface).equalsTo(containerFqName)) {
            SimpleFunctionDescriptor abstractMethod = this.functionResolver.resolveFunctionMutely(samInterfaceMethod, samInterface);
            assert (abstractMethod != null) : "couldn't resolve method " + samInterfaceMethod;
            return abstractMethod;
        }
        return JavaClassResolver.findFunctionWithMostSpecificReturnType(TypeUtils.getAllSupertypes(samInterface.getDefaultType()));
    }

    @NotNull
    private static SimpleFunctionDescriptor findFunctionWithMostSpecificReturnType(@NotNull Set<JetType> supertypes) {
        ArrayList<SimpleFunctionDescriptor> candidates = new ArrayList<SimpleFunctionDescriptor>(supertypes.size());
        for (JetType supertype : supertypes) {
            List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(supertype);
            if (abstractMembers.isEmpty()) continue;
            candidates.add((SimpleFunctionDescriptor)abstractMembers.get(0));
        }
        if (candidates.isEmpty()) {
            throw new IllegalStateException("Couldn't find abstract method in supertypes " + supertypes);
        }
        SimpleFunctionDescriptor currentMostSpecificType = (SimpleFunctionDescriptor)candidates.get(0);
        for (SimpleFunctionDescriptor candidate : candidates) {
            JetType candidateReturnType = candidate.getReturnType();
            JetType currentMostSpecificReturnType = currentMostSpecificType.getReturnType();
            assert (candidateReturnType != null && currentMostSpecificReturnType != null) : candidate + ", " + currentMostSpecificReturnType;
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(candidateReturnType, currentMostSpecificReturnType)) continue;
            currentMostSpecificType = candidate;
        }
        return currentMostSpecificType;
    }

    private void cache(@NotNull FqNameUnsafe fqName, @Nullable ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            this.cacheNegativeValue(fqName);
        } else {
            ClassDescriptor oldValue = this.classDescriptorCache.put(fqName, classDescriptor);
            assert (oldValue == null);
        }
    }

    private void checkFqNamesAreConsistent(@NotNull JavaClass javaClass, @NotNull FqName desiredFqName) {
        FqName fqName = javaClass.getFqName();
        assert (desiredFqName.equals(fqName)) : "Inconsistent FQ names: " + fqName + ", " + desiredFqName;
        FqNameUnsafe correctedName = JavaClassResolver.javaClassToKotlinFqName(fqName);
        if (this.classDescriptorCache.containsKey(correctedName) || this.unresolvedCache.contains(correctedName)) {
            throw new IllegalStateException("Cache already contains FQ name: " + fqName.asString());
        }
    }

    @NotNull
    private ClassOrNamespaceDescriptor resolveParentDescriptor(@NotNull FqName childClassFQName, boolean isInnerClass) {
        FqName parentFqName = childClassFQName.parent();
        if (isInnerClass) {
            ClassDescriptor parentClass = this.resolveClass(parentFqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
            if (parentClass == null) {
                throw new IllegalStateException("Could not resolve " + parentFqName + " required to be parent for " + childClassFQName);
            }
            return parentClass;
        }
        NamespaceDescriptor parentNamespace = this.namespaceResolver.resolveNamespace(parentFqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
        if (parentNamespace == null) {
            throw new IllegalStateException("Could not resolve " + parentFqName + " required to be parent for " + childClassFQName);
        }
        return parentNamespace;
    }

    @NotNull
    private static FqNameUnsafe javaClassToKotlinFqName(@NotNull FqName rawFqName) {
        ArrayList<Name> correctedSegments = new ArrayList<Name>();
        for (Name segment : rawFqName.pathSegments()) {
            if ("object".equals(segment.asString())) {
                assert (!correctedSegments.isEmpty());
                Name previous = (Name)correctedSegments.get(correctedSegments.size() - 1);
                correctedSegments.add(DescriptorUtils.getClassObjectName(previous));
                continue;
            }
            correctedSegments.add(segment);
        }
        return FqNameUnsafe.fromSegments(correctedSegments);
    }

    private static boolean isInnerClass(@NotNull JavaClass javaClass) {
        return javaClass.getOuterClass() != null && !javaClass.isStatic();
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode createClassObjectDescriptorForEnum(@NotNull ClassDescriptor containing, @NotNull JavaClass javaClass) {
        ClassDescriptorFromJvmBytecode classObjectDescriptor = this.createSyntheticClassObject(containing, javaClass);
        JetType valuesReturnType = KotlinBuiltIns.getInstance().getArrayType(containing.getDefaultType());
        SimpleFunctionDescriptor valuesMethod = DescriptorResolver.createEnumClassObjectValuesMethod((ClassDescriptor)classObjectDescriptor, valuesReturnType);
        classObjectDescriptor.getBuilder().addFunctionDescriptor(valuesMethod);
        JetType valueOfReturnType = containing.getDefaultType();
        SimpleFunctionDescriptor valueOfMethod = DescriptorResolver.createEnumClassObjectValueOfMethod((ClassDescriptor)classObjectDescriptor, valueOfReturnType);
        classObjectDescriptor.getBuilder().addFunctionDescriptor(valueOfMethod);
        return classObjectDescriptor;
    }

    @NotNull
    private ClassDescriptorFromJvmBytecode createSyntheticClassObject(@NotNull ClassDescriptor containing, @NotNull JavaClass javaClass) {
        ClassDescriptorFromJvmBytecode classObjectDescriptor = new ClassDescriptorFromJvmBytecode(containing, ClassKind.CLASS_OBJECT, false);
        classObjectDescriptor.setName(DescriptorUtils.getClassObjectName(containing.getName()));
        classObjectDescriptor.setModality(Modality.FINAL);
        classObjectDescriptor.setVisibility(containing.getVisibility());
        classObjectDescriptor.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        classObjectDescriptor.createTypeConstructor();
        JavaClassNonStaticMembersScope scope = new JavaClassNonStaticMembersScope(classObjectDescriptor, javaClass, true, this.memberResolver);
        WritableScopeImpl writableScope = new WritableScopeImpl(scope, classObjectDescriptor, RedeclarationHandler.THROW_EXCEPTION, "Member lookup scope");
        writableScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        classObjectDescriptor.setScopeForMemberLookup(writableScope);
        classObjectDescriptor.setScopeForConstructorResolve(scope);
        return classObjectDescriptor;
    }
}

