/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaValueParameterResolver {
    private JavaAnnotationResolver annotationResolver;
    private JavaTypeTransformer typeTransformer;

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    @NotNull
    private ValueParameterDescriptor resolveValueParameter(@NotNull DeclarationDescriptor containingDeclaration, int i, @NotNull JavaValueParameter parameter, @NotNull TypeVariableResolver typeVariableResolver) {
        JetType varargElementType;
        JetType outType;
        TypeUsage typeUsage = this.annotationResolver.hasMutableAnnotation(parameter) ? TypeUsage.MEMBER_SIGNATURE_COVARIANT : TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT;
        JavaType parameterType = parameter.getType();
        if (parameter.isVararg()) {
            assert (parameterType instanceof JavaArrayType) : "Vararg parameter should be an array: " + parameterType;
            JetType arrayType = this.typeTransformer.transformVarargType((JavaArrayType)parameterType, typeUsage, typeVariableResolver);
            outType = TypeUtils.makeNotNullable(arrayType);
            varargElementType = KotlinBuiltIns.getInstance().getArrayElementType(outType);
        } else {
            JetType transformedType = this.typeTransformer.transformToType(parameterType, typeUsage, typeVariableResolver);
            if (transformedType.isNullable() && this.annotationResolver.hasNotNullAnnotation(parameter)) {
                transformedType = TypeUtils.makeNotNullable(transformedType);
            }
            outType = transformedType;
            varargElementType = null;
        }
        return new ValueParameterDescriptorImpl(containingDeclaration, i, Collections.<AnnotationDescriptor>emptyList(), JavaValueParameterResolver.getParameterName(i, parameter), outType, false, varargElementType);
    }

    @NotNull
    private static Name getParameterName(int number, @NotNull JavaValueParameter parameter) {
        Name psiParameterName = parameter.getName();
        return psiParameterName != null ? psiParameterName : Name.identifier("p" + number);
    }

    @NotNull
    public List<ValueParameterDescriptor> resolveValueParameters(@NotNull DeclarationDescriptor container, @NotNull JavaMethod method, @NotNull TypeVariableResolver typeVariableResolver) {
        Collection<JavaValueParameter> parameters = method.getValueParameters();
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>(parameters.size());
        int index = 0;
        for (JavaValueParameter parameter : parameters) {
            result.add(this.resolveValueParameter(container, index, parameter, typeVariableResolver));
            ++index;
        }
        return result;
    }
}

