/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.util.slicedmap.BasicWritableSlice;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class TraceBasedErrorReporter
implements ErrorReporter {
    public static final WritableSlice<AbiVersionErrorLocation, Integer> ABI_VERSION_ERRORS = new BasicWritableSlice<AbiVersionErrorLocation, Integer>(Slices.ONLY_REWRITE_TO_EQUAL, true);
    private BindingTrace trace;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    @Override
    public void reportIncompatibleAbiVersion(@NotNull FqName fqName, @NotNull VirtualFile file, int actualVersion) {
        this.trace.record(ABI_VERSION_ERRORS, new AbiVersionErrorLocation(fqName, file), actualVersion);
    }

    public static final class AbiVersionErrorLocation {
        @NotNull
        private final FqName classFqName;
        @NotNull
        private final VirtualFile file;

        public AbiVersionErrorLocation(@NotNull FqName name, @NotNull VirtualFile file) {
            this.classFqName = name;
            this.file = file;
        }

        @NotNull
        public FqName getClassFqName() {
            return this.classFqName;
        }

        @NotNull
        public String getPath() {
            return this.file.getPath();
        }
    }
}

