/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeFieldSignatureData;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeMethodSignatureData;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.types.JetType;

public class TraceBasedExternalSignatureResolver
implements ExternalSignatureResolver {
    private BindingTrace trace;
    private JavaAnnotationResolver annotationResolver;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        SignaturesPropagationData data = new SignaturesPropagationData(owner, returnType, receiverType, valueParameters, typeParameters, (JavaMethodImpl)method, this.trace);
        return new ExternalSignatureResolver.PropagatedMethodSignature(data.getModifiedReturnType(), data.getModifiedReceiverType(), data.getModifiedValueParameters(), data.getModifiedTypeParameters(), data.getSignatureErrors(), data.getSuperFunctions());
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMethod method, boolean hasSuperMethods, @Nullable JetType returnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
        AlternativeMethodSignatureData data = new AlternativeMethodSignatureData(this.annotationResolver, (JavaMethodImpl)method, receiverType, valueParameters, returnType, typeParameters, hasSuperMethods);
        if (data.isAnnotated() && !data.hasErrors()) {
            return new ExternalSignatureResolver.AlternativeMethodSignature(data.getReturnType(), receiverType, data.getValueParameters(), data.getTypeParameters(), Collections.<String>emptyList());
        }
        List<String> error = data.hasErrors() ? Collections.singletonList(data.getError()) : Collections.emptyList();
        return new ExternalSignatureResolver.AlternativeMethodSignature(returnType, receiverType, valueParameters, typeParameters, error);
    }

    @Override
    @NotNull
    public ExternalSignatureResolver.AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField field, @NotNull JetType returnType, boolean isVar) {
        AlternativeFieldSignatureData data = new AlternativeFieldSignatureData(this.annotationResolver, (JavaFieldImpl)field, returnType, isVar);
        if (data.isAnnotated() && !data.hasErrors()) {
            return new ExternalSignatureResolver.AlternativeFieldSignature(data.getReturnType(), null);
        }
        String error = data.hasErrors() ? data.getError() : null;
        return new ExternalSignatureResolver.AlternativeFieldSignature(returnType, error);
    }

    @Override
    public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor, @NotNull List<String> signatureErrors) {
        this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor, signatureErrors);
    }
}

