/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.AnnotationUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceKind;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationArgumentResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaElement;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaFieldImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaMethodImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class TraceBasedJavaResolverCache
implements JavaResolverCache {
    private BindingTrace trace;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    @Override
    @Nullable
    public ClassDescriptor getClassResolvedFromSource(@NotNull FqName fqName) {
        return this.trace.get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, fqName);
    }

    @Override
    @Nullable
    public NamespaceDescriptor getPackageResolvedFromSource(@NotNull FqName fqName) {
        return this.trace.get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, fqName);
    }

    @Override
    @Nullable
    public SimpleFunctionDescriptor getMethod(@NotNull JavaMethod method) {
        return this.trace.get(BindingContext.FUNCTION, ((JavaMethodImpl)method).getPsi());
    }

    @Override
    @Nullable
    public ConstructorDescriptor getConstructor(@NotNull JavaElement constructor) {
        return this.trace.get(BindingContext.CONSTRUCTOR, ((JavaElementImpl)constructor).getPsi());
    }

    @Override
    @Nullable
    public ClassDescriptor getClass(@NotNull JavaClass javaClass) {
        return this.trace.get(BindingContext.CLASS, ((JavaClassImpl)javaClass).getPsi());
    }

    @Override
    public void recordMethod(@NotNull JavaMethod method, @NotNull SimpleFunctionDescriptor descriptor) {
        BindingContextUtils.recordFunctionDeclarationToDescriptor(this.trace, ((JavaMethodImpl)method).getPsi(), descriptor);
    }

    @Override
    public void recordConstructor(@NotNull JavaElement element, @NotNull ConstructorDescriptor descriptor) {
        this.trace.record(BindingContext.CONSTRUCTOR, ((JavaElementImpl)element).getPsi(), descriptor);
    }

    @Override
    public void recordField(@NotNull JavaField field, @NotNull PropertyDescriptor descriptor) {
        CompileTimeConstant<?> constant;
        PsiExpression initializer;
        PsiField psiField = (PsiField)((JavaFieldImpl)field).getPsi();
        this.trace.record(BindingContext.VARIABLE, psiField, descriptor);
        if (AnnotationUtils.isPropertyAcceptableAsAnnotationParameter(descriptor) && (initializer = psiField.getInitializer()) instanceof PsiLiteralExpression && (constant = JavaAnnotationArgumentResolver.resolveCompileTimeConstantValue(((PsiLiteralExpression)initializer).getValue(), descriptor.getType())) != null) {
            this.trace.record(BindingContext.COMPILE_TIME_INITIALIZER, descriptor, constant);
        }
    }

    @Override
    public void recordClass(@NotNull JavaClass javaClass, @NotNull ClassDescriptor descriptor) {
        this.trace.record(BindingContext.CLASS, ((JavaClassImpl)javaClass).getPsi(), descriptor);
    }

    @Override
    public void recordProperNamespace(@NotNull NamespaceDescriptor descriptor) {
        this.trace.record(JavaBindingContext.JAVA_NAMESPACE_KIND, descriptor, JavaNamespaceKind.PROPER);
    }

    @Override
    public void recordClassStaticMembersNamespace(@NotNull NamespaceDescriptor descriptor) {
        this.trace.record(JavaBindingContext.JAVA_NAMESPACE_KIND, descriptor, JavaNamespaceKind.CLASS_STATICS);
    }

    @Override
    public void recordPackage(@NotNull JavaElement element, @NotNull NamespaceDescriptor descriptor) {
        this.trace.record(BindingContext.NAMESPACE, ((JavaElementImpl)element).getPsi(), descriptor);
    }
}

